/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.filter;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.filters.AbstractHttpFilter;
import de.communardo.confluence.plugins.apc.license.APCLicenseService;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public class APCFilter
extends AbstractHttpFilter {
    private static final Pattern SERVLET_REQUEST_WHITELIST_PATTERN = Pattern.compile("/display|.*\\.action");
    private final APCUtils apcUtils;
    private final APCLicenseService apcLicenseService;

    public APCFilter(APCUtils apcUtils, APCLicenseService apcLicenseService) {
        this.apcUtils = apcUtils;
        this.apcLicenseService = apcLicenseService;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.apcLicenseService.isValidLicense()) {
            Matcher m = SERVLET_REQUEST_WHITELIST_PATTERN.matcher(request.getServletPath());
            if (m.find() && !this.apcUtils.isAPCMode(AuthenticatedUserThreadLocal.get(), request.getSession())) {
                String defaultUrl = this.apcUtils.getDefaultUrlByAPCUrl(request.getServletPath());
                if (defaultUrl != null) {
                    response.sendRedirect(this.apcUtils.getContextPath() + defaultUrl + (String)(StringUtils.isNotBlank((CharSequence)request.getQueryString()) ? "?" + request.getQueryString() : ""));
                } else {
                    this.redirectToDashboard(response);
                }
                return;
            }
        } else {
            this.redirectToDashboard(response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void redirectToDashboard(HttpServletResponse response) throws IOException {
        response.sendRedirect(this.apcUtils.getContextPath() + "/dashboard.action");
    }
}

