/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.entity;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XmlRootElement
public class PageEntity {
    @XmlElement
    private String displayTitle;
    @XmlElement
    private String id;
    @XmlElement
    private String urlPath;
    @XmlElement
    private List<PageEntity> children;
    @XmlElement
    private boolean isHomePage = false;
    @XmlElement
    private boolean isCurrentPage = false;

    public PageEntity(String displayTitle, String id, String urlPath) {
        this.displayTitle = displayTitle;
        this.id = id;
        this.urlPath = urlPath;
        this.children = null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<PageEntity> getChildren() {
        if (this.children == null) {
            this.children = Collections.emptyList();
        }
        return this.children;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public String getId() {
        return this.id;
    }

    public void addChild(PageEntity childPageEntity) {
        if (childPageEntity != null) {
            if (this.children == null) {
                this.children = new ArrayList<PageEntity>();
            }
            if (!this.children.contains(childPageEntity)) {
                this.children.add(childPageEntity);
            }
        }
    }

    public void setHomePage(boolean isHomePage) {
        this.isHomePage = isHomePage;
    }

    public boolean isHomePage() {
        return this.isHomePage;
    }

    public boolean isCurrentPage() {
        return this.isCurrentPage;
    }

    public void setCurrentPage(boolean currentPage) {
        this.isCurrentPage = currentPage;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setChildren(List<PageEntity> pageEntityChildren) {
        this.children = pageEntityChildren;
    }
}

