/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action.favourite;

import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class APCViewFavouritesAction
extends AbstractUserProfileAction {
    private static final String LABEL_NAME_MY_FAVOURITE = "my:favourite";
    private List<? extends ContentEntityObject> content;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        this.initContentsForLabel();
        return "success";
    }

    public Message getRelativeDate(Date date) {
        return new FriendlyDateFormatter(this.getDateFormatter()).getFormatMessage(date);
    }

    private void initContentsForLabel() {
        Label label = this.labelManager.getLabel(LabelParser.parse((String)LABEL_NAME_MY_FAVOURITE, (User)this.getAuthenticatedUser()));
        if (label != null) {
            this.content = this.getContentForLabel(label);
        }
    }

    private List<? extends ContentEntityObject> getContentForLabel(Label label) {
        List result = label != null ? this.labelManager.getContentForLabel(0, Integer.MAX_VALUE, label).getList() : Collections.emptyList();
        return this.permissionManager.getPermittedEntities(this.getAuthenticatedUser(), Permission.VIEW, result);
    }

    public boolean isReadOnlyModeEnabled() {
        AccessMode accessMode = this.accessModeService.getAccessMode();
        return accessMode.equals((Object)AccessMode.READ_ONLY);
    }

    public List<? extends ContentEntityObject> getContent() {
        if (this.content == null) {
            this.content = Collections.emptyList();
        }
        return this.content;
    }
}

