/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action.ImportedClasses;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ImportedCQLSearcher {
    private CQLSearchService searchService;

    @Inject
    public ImportedCQLSearcher(@ComponentImport CQLSearchService searchService) {
        this.searchService = searchService;
    }

    public SearchResultTotalSize getCqlSearchResults(String cql, SearchQueryParameters searchQuery) throws BadRequestException {
        SearchOptions searchOptions = SearchOptions.builder().excerptStrategy(SearchOptions.Excerpt.HIGHLIGHT).includeArchivedSpaces(searchQuery.isIncludeArchivedSpaces()).fireSearchPerformed(true).build();
        if (StringUtils.isBlank((CharSequence)cql)) {
            SearchPageResponse cqlSearchResults = this.searchService.search("space.type=global OR space.type=favorite OR space.type=personal", searchOptions, (PageRequest)new SimplePageRequest(searchQuery.getStartIndex(), searchQuery.getPageSize()), new Expansion[0]);
            List results = cqlSearchResults.getResults();
            return new SearchResultTotalSize(cqlSearchResults.totalSize(), results);
        }
        SearchPageResponse cqlSearchResults = this.searchService.search(cql, searchOptions, (PageRequest)new SimplePageRequest(searchQuery.getStartIndex(), searchQuery.getPageSize()), new Expansion[0]);
        List results = cqlSearchResults.getResults();
        return new SearchResultTotalSize(cqlSearchResults.totalSize(), results);
    }

    public static class SearchResultTotalSize {
        int totalSize;
        List<SearchResult> searchResult;

        public SearchResultTotalSize(int totalSize, List<SearchResult> searchResult) {
            this.totalSize = totalSize;
            this.searchResult = searchResult;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public List<SearchResult> getSearchResult() {
            return this.searchResult;
        }
    }
}

