/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.user.actions.UserAware;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class APCViewUserProfileAction
extends AbstractUserProfileAction
implements FormAware,
UserAware {
    private String username;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        if (this.getUser() == null) {
            return "pagenotfound";
        }
        if (this.getPersonalInformationEntity() != null) {
            this.addToHistory((ContentEntityObject)this.getPersonalInformationEntity());
        }
        return super.execute();
    }

    protected List<String> getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        if (!this.isAnonymousUser()) {
            return permissionTypes;
        }
        this.addPermissionTypeTo("VIEWUSERPROFILES", permissionTypes);
        return permissionTypes;
    }

    public List<String> getUserDetailsKeys(String groupKey) {
        return this.userDetailsManager.getProfileKeys(groupKey);
    }

    public boolean isEmailVisible() {
        return this.isMyProfile() || super.isEmailVisible();
    }

    public String getUsername() {
        if (StringUtils.isEmpty((CharSequence)this.username) && this.getAuthenticatedUser() != null) {
            this.username = this.getAuthenticatedUser().getName();
        }
        return this.username;
    }

    @StrutsParameter
    public void setUsername(String username) {
        if (HtmlUtil.shouldUrlDecode((String)username)) {
            username = HtmlUtil.urlDecode((String)username, (Charset)StandardCharsets.UTF_8);
        }
        this.username = username;
    }

    public boolean isEditMode() {
        return false;
    }

    public String getEmail() {
        return super.getEmail() == null ? null : GeneralUtil.alwaysMaskEmail((String)super.getEmail().toString());
    }
}

