/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbAware;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbGenerator;
import com.atlassian.confluence.util.breadcrumbs.spaceia.BlogPostDateBreadcrumb;
import com.atlassian.core.util.DateUtils;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import de.communardo.confluence.plugins.apc.bucket.core.actions.ManualTotalPaginationSupport;
import de.communardo.confluence.plugins.apc.bucket.core.actions.PaginationSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class APCViewBlogPostsAction
extends ConfluenceActionSupport
implements Spaced,
BreadcrumbAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(APCViewBlogPostsAction.class);
    private static final int PAGE_SIZE = 10;
    private SpaceService spaceService;
    private SearchManager searchManager;
    private PredefinedSearchBuilder predefinedSearchBuilder;
    private PageManager pageManager;
    private BreadcrumbGenerator breadcrumbGenerator;
    private String spaceKey;
    private int startIndex = 0;
    private PaginationSupport<BlogPost> paginationSupport;
    private int period = 5;
    private String postingDate;
    private Calendar postingDay;
    private boolean isOldestPage = false;
    private List<BlogPost> blogPosts;
    private boolean isDateView;
    private int totalBlogPostCount = 0;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        boolean bl = this.isDateView = this.postingDate != null;
        if (this.isDateView) {
            try {
                this.postingDay = Calendar.getInstance();
                this.postingDay.setTime(new SimpleDateFormat("yyyy/MM/dd").parse(this.postingDate));
                DateUtils.toStartOfPeriod((Calendar)this.postingDay, (int)this.period);
                this.blogPosts = this.getBlogPostsForDate();
                return "success";
            }
            catch (ParseException e) {
                this.addActionError("date.notvalid", new Object[]{this.postingDate});
                return "error";
            }
        }
        this.blogPosts = this.getBlogPosts();
        return "success";
    }

    private List<BlogPost> getBlogPostsForDate() {
        List blogPosts;
        BlogPost lastPost;
        this.totalBlogPostCount = (int)this.pageManager.getBlogPostCount(this.spaceKey, this.postingDay, this.period);
        if (this.totalBlogPostCount <= 0) {
            this.isOldestPage = true;
            return null;
        }
        if (this.totalBlogPostCount < 10) {
            this.isOldestPage = true;
        }
        if (this.pageManager.findPreviousBlogPost(lastPost = (BlogPost)(blogPosts = this.pageManager.getBlogPosts(this.spaceKey, this.postingDay, this.period, this.startIndex, 10)).get(blogPosts.size() - 1)) == null) {
            this.isOldestPage = true;
        }
        return blogPosts;
    }

    private List<BlogPost> getBlogPosts() {
        SearchResults searchResults = this.getSearchResults();
        if (searchResults != null) {
            this.totalBlogPostCount = searchResults.getUnfilteredResultsCount();
            return this.searchManager.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION).stream().map(searchable -> (BlogPost)searchable).toList();
        }
        return new ArrayList<BlogPost>();
    }

    private SearchResults getSearchResults() {
        SearchQueryParameters params = new SearchQueryParameters();
        params.setContentTypes(this.getContentTypes());
        params.setSort((SearchSort)new CreatedSort(SearchSort.Order.DESCENDING));
        params.setSpaceKey(this.spaceKey);
        ISearch search = this.predefinedSearchBuilder.buildSiteSearch(params, this.startIndex, 10);
        try {
            return this.searchManager.search(search);
        }
        catch (InvalidSearchException e) {
            LOGGER.error("Error while searching for blog posts", (Throwable)e);
            return null;
        }
    }

    public Space getSpace() {
        return this.spaceService.getKeySpaceLocator(this.spaceKey).getSpace();
    }

    public Breadcrumb getBreadcrumb() {
        if (this.isDateView) {
            Breadcrumb parent = this.breadcrumbGenerator.getBlogCollectorBreadcrumb(this.getSpace());
            return new BlogPostDateBreadcrumb(this.getSpace(), this.getPostingYear(), this.getPostingMonthNumeric(), this.getPostingMonth(), this.getPostingDayOfMonth(), parent);
        }
        return null;
    }

    public String getPostingDayOfMonth() {
        return this.postingDay != null ? new SimpleDateFormat("dd").format(this.postingDay.getTime()) : "";
    }

    public String getPostingYear() {
        return this.postingDay != null ? new SimpleDateFormat("yyyy").format(this.postingDay.getTime()) : "";
    }

    public String getPostingMonthNumeric() {
        return this.postingDay != null ? new SimpleDateFormat("MM").format(this.postingDay.getTime()) : "";
    }

    public String getPostingMonth() {
        return this.postingDay != null ? new SimpleDateFormat("MMMM").format(this.postingDay.getTime()) : "";
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    @StrutsParameter
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @StrutsParameter
    public void setKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @StrutsParameter
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public PaginationSupport<BlogPost> getPaginationSupport() {
        if (this.paginationSupport == null) {
            this.paginationSupport = new ManualTotalPaginationSupport<BlogPost>(this.blogPosts, this.startIndex, this.totalBlogPostCount, 10);
        }
        return this.paginationSupport;
    }

    public int getPeriod() {
        return this.period;
    }

    @StrutsParameter
    public void setPeriod(int period) {
        this.period = period;
    }

    public String getPostingDate() {
        return this.postingDate;
    }

    @StrutsParameter
    public void setPostingDate(String postingDate) {
        this.postingDate = postingDate;
    }

    public boolean isOldestPage() {
        return this.isOldestPage;
    }

    public boolean isDateView() {
        return this.isDateView;
    }

    public String getFormattedDateRangeDescription() {
        if (this.postingDay == null) {
            return "";
        }
        if (this.period == 5) {
            return this.getDateFormatter().formatServerDate(this.postingDay.getTime());
        }
        Calendar localCalendar = Calendar.getInstance(this.getDateFormatter().getTimeZone().getWrappedTimeZone());
        GeneralUtil.copyDate((Calendar)this.postingDay, (Calendar)localCalendar);
        return this.getDateFormatter().formatGivenString("MMMMMMMMM, yyyy", localCalendar.getTime());
    }

    public Set<ContentTypeEnum> getContentTypes() {
        HashSet<ContentTypeEnum> contentTypes = new HashSet<ContentTypeEnum>();
        contentTypes.add(ContentTypeEnum.BLOG);
        return contentTypes;
    }

    public boolean isBlogPostsByDateAction() {
        return true;
    }

    public boolean isReadOnlyModeEnabled() {
        AccessMode accessMode = this.accessModeService.getAccessMode();
        return accessMode.equals((Object)AccessMode.READ_ONLY);
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public void setPredefinedSearchBuilder(PredefinedSearchBuilder predefinedSearchBuilder) {
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setBreadcrumbGenerator(BreadcrumbGenerator breadcrumbGenerator) {
        this.breadcrumbGenerator = breadcrumbGenerator;
    }
}

