/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.pages.actions.EditPageAction;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;

@AnonymousSiteAccess
public class APCEditPageAction
extends EditPageAction {
    private APCUtils apcUtils;
    private ContentRepresentation contentRepresentation;
    private String unexpectedError;
    private StrutsWrapper strutsWrapper;

    public void validate() {
        this.contentRepresentation = this.apcUtils.getContentRepresentationFromRequestParameters(this.strutsWrapper.getParameterMap());
        String pageIdParam = this.strutsWrapper.getValueForRequestParameter("pageId");
        if (this.contentRepresentation != null) {
            this.setWysiwygContent(this.apcUtils.convertWikiMarkupToWysiwyg(this.contentRepresentation, Long.parseLong(pageIdParam)));
        }
        super.validate();
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doEdit() {
        if (this.contentRepresentation == null) {
            this.unexpectedError = this.getText("de.communardo.confluence.plugins.apc.messages.edit.save.unexpected-error");
            return "error";
        }
        return super.doEdit();
    }

    public String getUnexpectedError() {
        return this.unexpectedError;
    }

    public void setApcUtils(APCUtils apcUtils) {
        this.apcUtils = apcUtils;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

