/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.pages.actions.CreateBlogPostAction;
import com.atlassian.confluence.util.HtmlUtil;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@AnonymousSiteAccess
public class APCCreateBlogPostAction
extends CreateBlogPostAction {
    private APCUtils apcUtils;
    private StrutsWrapper strutsWrapper;
    private ContentRepresentation contentRepresentation;
    private String unexpectedError;

    public void validate() {
        String spaceKeyParam = this.strutsWrapper.getValueForRequestParameter("spaceKey");
        this.contentRepresentation = this.apcUtils.getContentRepresentationFromRequestParameters(this.strutsWrapper.getParameterMap());
        if (this.contentRepresentation != null) {
            super.setWysiwygContent(this.apcUtils.convertWikiMarkupToWysiwyg(this.contentRepresentation, spaceKeyParam));
        }
        super.validate();
    }

    public String doAdd() throws Exception {
        if (this.contentRepresentation == null) {
            this.unexpectedError = this.getText("de.communardo.confluence.plugins.apc.messages.edit.save.unexpected-error");
            return "error";
        }
        return super.doAdd();
    }

    public String getUnexpectedError() {
        return this.unexpectedError;
    }

    public String getCancelRedirectUrl() {
        return "viewblogposts.action?spaceKey=" + HtmlUtil.urlEncode((String)this.space.getKey(), (Charset)StandardCharsets.UTF_8);
    }

    public void setApcUtils(APCUtils apcUtils) {
        this.apcUtils = apcUtils;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

