// see also apc.js
AJS.$(document).ready(function($) {
	var errorRePositioning = function() {
		var labels = $('#login-container label');

	 	// remove our modifications from a previous run
		$('.error[id$="_error"], .aui-message.error', labels).remove(); // also removes error message which were present on load
		labels.removeAttr('style');

		// move error messages into their field's label
		$('#login-container .error[id$="_error"]').each(function() {
			var label = $(this).closest('.field-group').find('label');
			label.attr('style', 'width: 395px;');
			if (!$('.labelText', label).length) {
				label.wrapInner('<div class="labelText"></div>');
			}
			label.append(this);
		});

		// focus 1st erroneous input (directly the input and not the label, because IE8
		// apparently can't focus the linked input of a label when focus()ing the label)
		$('#login-container .error[id$="_error"]').filter(':first').closest('.field-group').find(':input').focus();
	}

	var loginErrorTimer;
	$('.aui.login-form-container').submit(function () {
		clearTimeout(loginErrorTimer); // clear any lingering timers, in case the user re-submitted the form before the timeout
		loginErrorTimer = setTimeout(errorRePositioning, 500);
	});
});
