AJS.toInit(function ($) {
    // taken from: http://accessibleculture.org/articles/2013/02/not-so-simple-aria-tree-views-and-screen-readers
    function initTreeviewFunctions($container) {
        if ($container.find('.treeview').length) {
            var $tree = $container.find('.treeview ul:first');
            $tree.attr({'role': 'tree'});
            //some regularly updated vars depending on nodes expanded/collapsed
            var $allNodes = $('li:visible', $tree);//object with all visible list item nodes
            var lastNodeIdx = $allNodes.length - 1;//last list item node's index
            var $lastNode = $allNodes.eq(lastNodeIdx);//last list item node visible
            function toggleGroup($node) {
                $toggle = $('> div', $node);
                $childList = $('> ul', $node);
                $childList.slideToggle('fast', function() {
                        //update relevant vars when a node is expanded/collapsed
                        $allNodes = $('li:visible', $tree);
                        lastNodeIdx = $allNodes.length - 1;
                        $lastNode = $allNodes.eq(lastNodeIdx);
                    }
                );
                if ($toggle.hasClass('collapsed')) {
                    $toggle.removeClass('collapsed').addClass('expanded');
                    $node.attr({'aria-expanded': 'true', 'tabindex': '0'});
                } else {
                    $toggle.removeClass('expanded').addClass('collapsed');
                    $node.attr({'aria-expanded': 'false', 'tabindex': '0'});
                }
            }
            //get next node
            function nextNode($node, dir) {
                var thisNodeIdx = $allNodes.index($node);
                if (dir == 'up' || dir == 'parent') {
                    var endNodeIdx = 0;
                    var operand = -1;
                } else {
                    var endNodeIdx = lastNodeIdx;
                    var operand = 1;
                }
                if (thisNodeIdx == endNodeIdx) {//if currentNode is last node
                    return false; //don't do anything

                }
                if (dir == 'parent') {
                    var parentNodeIdx = $allNodes.index($node.parent().parent());
                    var $nextNode = $allNodes.eq(parentNodeIdx);
                } else {
                    var $nextNode = $allNodes.eq(thisNodeIdx + operand);
                }
                $node.attr('tabindex', '-1');
                $nextNode.attr('tabindex', '0').focus();
            }
            //for each li in the tree
            $('li', $tree).each(function() {
                    var $node = $(this);
                    var $nodeSpan = $('> span', $node);
                    $node.attr({'role': 'treeitem', 'aria-selected': 'false', 'tabindex': '-1'});
                    //if children exist
                    if ($node.has('ul').length) {
                        $node.addClass('hasChildren');
                        $childList = $('ul', $node);
                        $childList.attr({'role': 'group'}).hide();
                        //add toggle element and set aria-expanded on the span
                        $('<div aria-hidden="true" class="toggle collapsed">').insertBefore($nodeSpan);
                        $node.attr('aria-expanded', 'false');
                    } else {//no children
                        $node.addClass('noChildren');
                    }
                    $node.on('keydown', function(e){
                            if (!(e.shiftKey || e.ctrlKey || e.altKey || e.metaKey)) {
                                switch(e.which) {
                                    case 38: //up
                                        e.preventDefault();
                                        e.stopPropagation();
                                        nextNode($node, 'up');
                                        break;
                                    case 40: //down
                                        e.preventDefault();
                                        e.stopPropagation();
                                        nextNode($node, 'down');
                                        break;
                                    case 37: //left
                                        e.preventDefault();
                                        e.stopPropagation();
                                        if ($node.attr('aria-expanded') == 'false' || $node.is('.noChildren')) {
                                            nextNode($node, 'parent');
                                        } else {
                                            toggleGroup($node);
                                        }
                                        break;
                                    case 39: //right
                                        e.preventDefault();
                                        e.stopPropagation();
                                        if ($node.attr('aria-expanded') == 'true') {
                                            nextNode($node, 'down');
                                        } else {
                                            toggleGroup($node);
                                        }
                                        break;
                                    case 13: //enter
                                        e.preventDefault();
                                        e.stopPropagation();
                                        // Find the first focusable child (a) and trigger click
                                        var $focusable = $node.find('a').first();
                                        if ($focusable.length && $focusable.attr('href')) {
                                            $focusable.get(0).click();
                                        }
                                        break;
                                }
                            }
                        }
                    ).on('focus', function() {
                            $('> span', $node).addClass('focussed');
                            $('[aria-selected="true"]', $tree).attr('aria-selected', 'false');
                            $(this).attr('aria-selected', 'true');
                        }
                    ).on('blur', function() {
                            $('> span', $node).removeClass('focussed');
                        }
                    );
                }
            );
            //set tabindex="0" on first node in the tree
            $('> li:first', $tree).attr('tabindex', '0');
            //toggle div click and hover
            $('.toggle').on('click', function() {
                    toggleGroup($(this).parent());
                }
            ).hover(
                function() {
                    $(this).toggleClass('hover');
                }
            );
        }
    }

    var rw_disable_category_dashboards = jQuery("#rw_disable_category_dashboards"),
        rw_disable_subcategory_dashboards = jQuery("#rw_disable_subcategory_dashboards");
    if (rw_disable_category_dashboards.length && rw_disable_subcategory_dashboards.length) {
        var renderRefinedNavItem = function (item, isChild) {
            var categoryUrl;
            var itemType = "";
            switch (item.type) {
                case 'category':
                    if (isChild)
                        itemType = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.subcategory');
                    else
                        itemType = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.category');
                    break;
                case 'space':
                    itemType = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.space');
                    break;
                case 'page':
                    itemType = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.page');
                    break;
                case 'blog':
                    itemType = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.blog');
                    break;
                case 'link':
                    itemType = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.link');
                    break;
                case 'html':
                    itemType = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.html');
                    break;
                default:
                    itemType = "";
            }
            if (item.type === "category") {
                // check if category dashboards are disabled; set in refinedwiki.vm; relevant for RefinedTheme 5
                if (rw_disable_category_dashboards.text() === "false") {
                    // url is added if it's a category or a subcategory
                    if (!isChild || (isChild && rw_disable_subcategory_dashboards.text() === "false"))
                        // defaultLink == true -> we have a category without custom url
                        if (item.link.defaultLink) {
                            categoryUrl = AJS.contextPath() + "/apc/category/category-dashboard.action?categoryKey=" + item.nameKey;
                        } else {
                            categoryUrl = item.link.url;
                        }
                }
            } else if (item.type !== "blog") {
                // blog modules shouldn't display dashboard links
                categoryUrl = item.url;
            }
            var hasChildrenOrSubcategories = (item.children && item.children.length > 0) || (item.subCategories && item.subCategories.length > 0);
            // items with children or subcategories need 'hasChildren' class
            var liClass = (hasChildrenOrSubcategories) ? 'hasChildren' : 'noChildren';
            // items with children or subcategories need 'toggle collapsed' metadata
            var liContent = (hasChildrenOrSubcategories) ? '<div aria-hidden="true" class="toggle collapsed"></div>' : '';
            var li = jQuery("<li role='treeitem' aria-selected='false' class='" + liClass + "' aria-expanded='false'>" + liContent);

            // add link to category dashboard
            if (categoryUrl)
                li.append(jQuery("<a>")
                    .text(itemType + " - " + (item.name || item.title))
                    .attr('href', categoryUrl)
                );
            else
                li.text(itemType + " - " + (item.name || item.title));

            var subItems = [];
            item.children && item.children.forEach(function (child) {
                subItems.push(renderRefinedNavItem(child));
            });
            item.subCategories && item.subCategories.forEach(function (subCategory) {
                subItems.push(renderRefinedNavItem(subCategory, true));
            });

            if (subItems.length) {
                li.append(jQuery("<ul class='children' role='group' style='display: none;'>").append(subItems))
            }

            return li[0]; // no jQuery
        };

        jQuery.ajax(contextPath + "/rest/refinedtheme/2.0/category?recursive=true&include-children=true")
            .success(function (data) {
                var items = [];
                data.forEach(function (item) {
                    items.push(renderRefinedNavItem(item));
                });

                if (items.length) {
                    var refinedWikiNav = jQuery('<div id="apc-refinedwiki-organizer">')
                        .append(jQuery('<a id="apc-skiplink-refinedwiki-organizer" href="#apc-skiplink-refinedwiki-organizer" role="heading"><h2>' + AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.refined.content') + '</h2></a>'))
                        .append(jQuery('<div class="treeview"/>')
                        .append(jQuery('<ul class="tree" role="tree">').append(items)));

                    jQuery('#quicksearch').after(refinedWikiNav);
                    // add skip link for redefined wiki navigation
                    jQuery('#skip-links').find('a[href="#apc-skiplink-quicksearch"]').parent().after(jQuery('<li><a href="#apc-skiplink-refinedwiki-organizer" title="' + AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.skip.links.refinedNavigation') + '">' + AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.skip.links.refinedNavigation') + '</a></li>'));
                }
                initTreeviewFunctions(refinedWikiNav);
            })
            .fail(function () {
                console.log("RefinedWiki Integration failed:", arguments);
            });
    }
});
