/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.compatibility.search;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SiteSearchPermissionsQueryFactory;
import com.atlassian.confluence.search.v2.query.ActiveUserQuery;
import com.atlassian.confluence.search.v2.query.ArchivedSpacesQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.spaces.SpaceManager;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilder;
import java.util.ArrayList;

public class ContentSearchBuilderFactory {
    private final SpaceManager spaceManager;
    private final SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory;

    public ContentSearchBuilderFactory(SpaceManager spaceManager, SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory) {
        this.spaceManager = spaceManager;
        this.siteSearchPermissionsQueryFactory = siteSearchPermissionsQueryFactory;
    }

    public ContentSearchBuilder createContentSearchBuilder() {
        return new ContentSearchBuilder(contentSearchBuilder -> {
            ArrayList<SearchQuery> mustQueriesForSearch = new ArrayList<SearchQuery>(contentSearchBuilder.mustQueries);
            if (contentSearchBuilder.excludeArchivedSpaces) {
                mustQueriesForSearch.add((SearchQuery)new ArchivedSpacesQuery(false, this.spaceManager));
            }
            if (contentSearchBuilder.useSiteSearchPermissionFilter) {
                mustQueriesForSearch.add(this.siteSearchPermissionsQueryFactory.create());
            }
            if (contentSearchBuilder.excludeInactiveUsers) {
                mustQueriesForSearch.add((SearchQuery)ActiveUserQuery.getInstance());
            }
            return new ContentSearch((SearchQuery)new BooleanQuery(mustQueriesForSearch, null, null), contentSearchBuilder.sort, contentSearchBuilder.startOffset, contentSearchBuilder.limit);
        });
    }
}

