/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import de.communardo.confluence.plugins.apc.bucket.core.actions.ManualTotalPaginationSupport;
import de.communardo.confluence.plugins.apc.bucket.core.actions.PaginationSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class APCSpacesAction
extends ConfluenceActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(APCSpacesAction.class);
    private static final int DEFAULT_PAGE_SIZE = 10;
    private SpaceService spaceService;
    private SearchManager searchManager;
    private PredefinedSearchBuilder predefinedSearchBuilder;
    private int globalStartIndex;
    private int personalStartIndex;
    private PaginationSupport<Space> globalPaginationSupport;
    private PaginationSupport<Space> personalPaginationSupport;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        return "success";
    }

    @StrutsParameter
    public void setGlobalStartIndex(int globalStartIndex) {
        this.globalStartIndex = globalStartIndex;
    }

    @StrutsParameter
    public void setPersonalStartIndex(int personalStartIndex) {
        this.personalStartIndex = personalStartIndex;
    }

    public PaginationSupport<Space> getGlobalPaginationSupport() {
        SearchResults searchResults;
        if (this.globalPaginationSupport == null && (searchResults = this.getSearchResults(SpaceDirectoryScope.GLOBAL, this.globalStartIndex)) != null) {
            this.globalPaginationSupport = new ManualTotalPaginationSupport<Space>(this.getSpaceList(searchResults), this.globalStartIndex, searchResults.getUnfilteredResultsCount(), 10);
        }
        return this.globalPaginationSupport;
    }

    public PaginationSupport<Space> getPersonalPaginationSupport() {
        SearchResults searchResults;
        if (this.personalPaginationSupport == null && (searchResults = this.getSearchResults(SpaceDirectoryScope.PERSONAL, this.personalStartIndex)) != null) {
            this.personalPaginationSupport = new ManualTotalPaginationSupport<Space>(this.getSpaceList(searchResults), this.personalStartIndex, searchResults.getUnfilteredResultsCount(), 10);
        }
        return this.personalPaginationSupport;
    }

    public String getStartUrl(Space space) {
        return space.getDeepLinkUri().toASCIIString();
    }

    private SearchResults getSearchResults(SpaceDirectoryScope spaceDirectoryScope, int startIndex) {
        SearchQueryParameters params = new SearchQueryParameters();
        params.setContentTypes(spaceDirectoryScope.getContentTypes());
        params.setSort((SearchSort)TitleSort.ASCENDING);
        ISearch search = this.predefinedSearchBuilder.buildSiteSearch(params, startIndex, 10);
        try {
            return this.searchManager.search(search);
        }
        catch (InvalidSearchException e) {
            LOGGER.error("Error while searching for spaces", (Throwable)e);
            return null;
        }
    }

    private List<Space> getSpaceList(SearchResults searchResults) {
        ArrayList<Space> spaceList = new ArrayList<Space>();
        for (SearchResult searchResult : searchResults) {
            Space space = this.spaceService.getKeySpaceLocator(searchResult.getSpaceKey()).getSpace();
            if (space == null) continue;
            spaceList.add(space);
        }
        return spaceList;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    public void setPredefinedSearchBuilder(PredefinedSearchBuilder predefinedSearchBuilder) {
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    private static enum SpaceDirectoryScope {
        PERSONAL(ContentTypeEnum.PERSONAL_SPACE_DESCRIPTION),
        GLOBAL(ContentTypeEnum.SPACE_DESCRIPTION);

        private final Set<ContentTypeEnum> contentTypes = new HashSet<ContentTypeEnum>();

        private SpaceDirectoryScope(ContentTypeEnum ... contentTypes) {
            Collections.addAll(this.contentTypes, contentTypes);
        }

        public Set<ContentTypeEnum> getContentTypes() {
            return this.contentTypes;
        }
    }
}

