AJS.toInit(function ($) {

    // # following code is for space cetegories/labels

    // make labels/categories removable with pressing ENTER
    $('span.aui-icon-close').each(function (){
        $(this).keypress(function( event ) {
            if ( event.which == 13 ) {
                event.preventDefault();
                $(this).click();
            }
        });
    });

    // # following code is for createspace.vm
    var createSpaceSelect = jQuery("#createSpaceSelect");
    var createSpaceForm = jQuery('#apc-create-space-form');
    var createSpaceBtn = jQuery('#apcCreateSpaceSubmit');
    var createSpaceBlueprintIdInput = jQuery('#apcCreateSpaceBlueprintIdInput');
    if (createSpaceSelect.length && createSpaceForm.length && createSpaceBtn.length && createSpaceBlueprintIdInput.length) {
        // load all accessible space blueprints from Confluence
        jQuery.ajax(contextPath + "/rest/create-dialog/1.0/space-blueprint/dialog/web-items")
            .success(function (data) {
                data.forEach(function (item) {
                    // 3rd party blueprints have the 'isNew'-attribute set to true
                    var itemDescription = $("<div>").text(item.description).html();
                    var itemName = $("<div>").text(item.name).html();
                    createSpaceSelect.append($('<option data-blueprintId="' + item.contentBlueprintId + '" value="' + item.contentBlueprintId + '">' + itemName + ' (' + AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.space.create.description') + ': ' + itemDescription + ')' + '</option>'))
                });
            })
            .fail(function () {
                console.log("Loading space blueprints failed:", arguments);
            });

        createSpaceBtn.click(function () {
            createSpaceBlueprintIdInput.val($('#createSpaceSelect option:selected').attr('data-blueprintId'));
            createSpaceForm.submit();
        })
    }

    // # following code is for configurenewspace.vm
    var configureSpaceDiv = jQuery("#apcConfigureSpaceForm");
    var configureSpaceSubmitBtn = jQuery("#apcConfigureSpaceSubmit");

    function createErrorMessage(errorMessage) {
        var spaceKeyInput = $('input[name=spaceKey]');
        if (spaceKeyInput.attr('data-has-error') !== 'true') {
            var errorDiv = $('<div role="alert" class="error-area">');
            errorDiv.text(errorMessage);
            spaceKeyInput.attr("aria-invalid", "true");
            spaceKeyInput.parent().append(errorDiv);
            spaceKeyInput.attr('data-has-error', 'true');
        }
    }

    if (configureSpaceDiv.length && configureSpaceSubmitBtn.length) {
        // check if space blueprints were loaded by #requireResourcesForContext("create-space")
        if (window["Confluence"]["SpaceBlueprints"]) {
            var spaceBlueprintId = configureSpaceDiv.attr("data-spaceBlueprintId");
            // retrieve the blueprint's templateKey and description
            jQuery.ajax(contextPath + "/rest/create-dialog/1.0/space-blueprint/dialog/web-items")
                .success(function (data) {
                    data.forEach(function (item) {
                        if (item.contentBlueprintId === spaceBlueprintId) {
                            var splittedTemplateKey = item.wizard.pages[0].templateKey.split('.');
                            var descriptionParagraph = $('<p>' + item.wizard.pages[0].descriptionContent + '</p>');
                            configureSpaceDiv.prepend(descriptionParagraph);
                            var htmlForm;
                            // check if we create an empty/personal space or a blueprint space
                            var isPersonalSpace = false;
                            if (splittedTemplateKey && splittedTemplateKey[1] === "Templates") {
                                if (splittedTemplateKey.length > 4) {
                                    if (splittedTemplateKey[4] === "createPersonalSpaceForm") {
                                        // get html form of personal space
                                        isPersonalSpace = true;
                                        htmlForm = jQuery(Confluence.Templates.Blueprints.CreateSpace.createPersonalSpaceForm());
                                    } else if (splittedTemplateKey[4] === "createSpaceForm") {
                                        // get html form of empty space; requires showSpacePermission
                                        htmlForm = jQuery(Confluence.Templates.Blueprints.CreateSpace.createSpaceForm({showSpacePermission: true}));
                                    } else {
                                        console.log("Error: Expecting empty or personal space.");
                                    }
                                } else {
                                    console.log("Error: Space Blueprint's template key has wrong format.");
                                }
                            } else if (splittedTemplateKey && splittedTemplateKey[1] === "SpaceBlueprints") {
                                // get html form of the space blueprint
                                htmlForm = jQuery(window["Confluence"]["SpaceBlueprints"][splittedTemplateKey[2]]["dialogForm"]({}));
                            }
                            // find all inputs with missing id-attributes and fix them; inputs only have 'name'-attribute
                            htmlForm.find('input.text').each(function () {
                                $(this).attr("id", $(this).attr("name"))
                            });
                            // find all required fields and add 'required' to label
                            htmlForm.find('.aui-icon.icon-required').parent().text(function () {
                                $(this).text($(this).text() + ' (' + AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.space.create.required') + ')')
                            });
                            // find all tooltips and add them to label
                            htmlForm.find('span.aui-icon.aui-icon-small.aui-iconfont-help').each(function () {
                                var tooltip = $(this).attr("data-tooltip");
                                $(this).parent().find('label').each(function () {
                                    $(this).text($(this).text() + " (" + tooltip + ")")
                                })
                            });

                            // load autocomplete field js code and create autocomplete widget
                            var Autocomplete = require('communardo/confluence/accessibility/autocomplete');

                            // find all inputs with class .autocomplete-multiuser and replace with accessible autocomplete field
                            htmlForm.find('input.autocomplete-multiuser').each(function () {
                                $(this).prop("type", "hidden");
                                var autocompleteWidget = $('<div data-widget="accessible-autocomplete-users">\n' +
                                    '                    <label for="search">' + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.sharepage.searchFor") + '</label>\n' +
                                    '                    <input type="text" id="search" autocomplete="off" class="autocomplete-search-field" aria-describedby="initInstr" aria-owns="results" aria-expanded="false" aria-autocomplete="both" aria-activedescendant="">\n' +
                                    '                    <input id="apcsharepageid" type="hidden" name="apcsharepageid" value="$action.pageId" />\n' +
                                    '                    <input id="apcsharecontenttype" type="hidden" name="apcsharecontenttype" value="$action.page.type" />\n' +
                                    '                    <input id="apcusername" type="hidden" name="apcusername" value="" />\n' +
                                    '                    <input id="apcuserKey" type="hidden" name="apcuserKey" value="" />\n' +
                                    '                    <input id="apcgroupname" type="hidden" name="apcgroupname" value="" />\n' +
                                    '                    <button type="button" id="clearText">' + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.sharepage.clearText") + '</button>\n' +
                                    '                    <button type="button" id="addUser">' + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.space.create.team.memberlist.addUser") + '</button>\n' +
                                    '                    <ul id="results" class="autocomplete-list" role="listbox" tabindex="0" style="display: none;"></ul>\n' +
                                    '                    <span id="initInstr" style="display: none;">' + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.autocomplete.initInstr") + '</span>\n' +
                                    '                    <div aria-live="assertive" class="screen-reader-text"></div>\n' +
                                    '                    <div>\n' +
                                    '                        <label>' + AJS.I18n.getText("de.communardo.confluence.plugins.apc.messages.space.create.team.memberlist") + ':</label>\n' +
                                    '                        <ul id="recipientList"></ul>\n' +
                                    '                    </div>\n' +
                                    '               </div>');

                                // register accessibility autocomplete widget with original input. this is needed for the context which is created in create-space REST call
                                // every change in accessible widget is transferred to the hidden input
                                Autocomplete.init(autocompleteWidget, this);

                                $(this).after(autocompleteWidget);
                            });

                            descriptionParagraph.after(htmlForm);

                            // set correct position of result lists of autocomplete field after the whole form was inserted into the page
                            configureSpaceDiv.find('ul.autocomplete-list').each(function () {
                                var inputField = $(this).parent().find('input.autocomplete-search-field');
                                if (inputField.length)
                                    Autocomplete.rePositionResults(this, inputField[0])
                            });

                            // move submitButton into form for correct submit-form-event
                            configureSpaceSubmitBtn.appendTo(htmlForm);

                            // focus first input/select field
                            htmlForm.find('input.text,select').filter(':visible:first').focus();

                            // auto key generation for a given space name BFC-668
                            var $spaceKeyInput = htmlForm.find('input[name=spaceKey]'),
                                $spaceNameInput = htmlForm.find('input[name=name]'),
                                // we need different name attributes to find the description since the different forms
                                // to create a space don't have a convention regarding the name
                                $spaceDescriptionTextArea = htmlForm.find('textarea[name=spaceDesc], textarea[name=description]');
                            if ($spaceKeyInput.length && $spaceNameInput.length){
                                var keyGenerator = KeyGenerator();
                                $spaceNameInput.change(function () {
                                    $spaceKeyInput.val(keyGenerator.generateKey($spaceNameInput.val()))
                                })
                            }

                            htmlForm.submit(function (e) {
                                e.preventDefault(); // avoid to execute the actual submit of the form.
                                if(isPersonalSpace){
                                    var urlCreateSpace = "/rest/create-dialog/1.0/space-blueprint/create-personal-space";
                                    var spaceData = {
                                        "spaceUserKey": ""
                                    };

                                    $.ajax({
                                        url: contextPath + urlCreateSpace,
                                        type: "POST",
                                        data: JSON.stringify(spaceData),
                                        contentType: "application/json; charset=utf-8",
                                        dataType: "json",
                                        success: function (data) {
                                            window.location.replace(data.url);
                                        }
                                    });
                                } else {
                                    var spaceKey = $spaceKeyInput.val();
                                    var spaceName = $spaceNameInput.val();
                                    var spaceDescription = $spaceDescriptionTextArea.length > 0 ? $spaceDescriptionTextArea.val() : "";
                                    if (spaceKey && spaceName) {
                                        jQuery.ajax(contextPath + "/ajax/spaceavailable.action?key=" + spaceKey)
                                            .success(function (data) {
                                                if (data.available) {
                                                    var urlCreateSpace = "/rest/create-dialog/1.0/space-blueprint/create-space";
                                                    var spaceData = {
                                                        "spaceKey": spaceKey,
                                                        "name": spaceName,
                                                        "description": spaceDescription,
                                                        "spaceBlueprintId": spaceBlueprintId,
                                                        "context": {
                                                        "atl_token": AJS.Confluence.getXsrfToken(),
                                                            "ContentPageTitle": spaceName
                                                        }
                                                    };
                                                    // collect all values from inputs or textareas for the context object
                                                    htmlForm.find('input.text,textarea.textarea').each(function () {
                                                        spaceData.context[$(this).attr("name")] = $(this).val();
                                                    });

                                                    console.log(spaceData);

                                                    $.ajax({
                                                        url: contextPath + urlCreateSpace,
                                                        type: "POST",
                                                        data: JSON.stringify(spaceData),
                                                        contentType: "application/json; charset=utf-8",
                                                        dataType: "json",
                                                        success: function (data) {
                                                            window.location.replace(data.url);
                                                        }
                                                    });
                                                } else {
                                                    // space key is already in use; create error message
                                                    createErrorMessage(data.message);
                                                }
                                            })
                                            .fail(function () {
                                                console.log("Cannot determine if space with key '" + spaceKey + "' is available:", arguments);
                                            });
                                    } else {
                                        createErrorMessage(AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.space.configure.fillRequiredFields'));
                                    }
                                }
                            })
                        }
                    });
                })
                .fail(function () {
                    console.log("Loading space blueprints failed:", arguments);
                });
        }
    }
});