AJS.toInit(function($) {
    var apcProfile = {
        shouldSubmitProfileForm : false,

        isOriginalEmail : function() {
            return $('#originalemail').attr('value') === $('#email').attr('value');
        },

        submitEvent : function() {
            if (apcProfile.shouldSubmitProfileForm) {
                apcProfile.shouldSubmitProfileForm = false;
                if (!apcProfile.isOriginalEmail()) {
                    $('#passwordconfirmation').attr('value', $('#password').attr('value'));
                }
                return true;
            }
            if (!apcProfile.isOriginalEmail()) {
                var confirmationDialog = $(APC.Template.Profile.confirmation({
                    username : AJS.Data.get('remote-user')
                }));
                $('#apc-pre-confirm').after(confirmationDialog);
                $('#apc-confirm').attr('tabindex', '1').focus();
                apcProfile.shouldSubmitProfileForm = true;
                return false;
            }
            else {
                return true;
            }
        },

        cancelEvent : function() {
            apcProfile.shouldSubmitProfileForm = true;
            return true;
        },

        init : function() {
            $('#cancel').click(apcProfile.cancelEvent);
            $('#editmyprofileform').submit(apcProfile.submitEvent);
        }
    }
    apcProfile.init();

    // remove profile navigation
    $('.aui-navgroup').remove();
    
    // focus first error field (IE8: directly the input, NOT the label!)
    $('#' + $('div.error:first').parent('label').attr('for')).focus();
});