AJS.toInit(function($) {
    function tabIndexReplace() {
        var createDialog = AJS.$('#create-dialog');
        if (createDialog.length) {
            var linkToReplace = AJS.$('a.add-remove-customise-templates-trigger[tabindex="-1"]', createDialog);
            if (!linkToReplace.length) {
                setTimeout(tabIndexReplace, 1000);
                return;
            }
            else {
                linkToReplace.attr('tabindex', '0');
            }
        }
    }

    // adapted from https://accessibility.oit.ncsu.edu/training/aria/modal-window/version-3/
    var trapTabKey = function(container, event) {
        if (event.which == 9) { // tab or shift-tab
            // jQuery's ":focusable" doesn't work for .aui-dialog2's. dunno why.
            var focusableItems = container.find(apc.focusableElementsSelector).filter(':visible');

            var focusedItemIndex = focusableItems.index($(':focus'));
            if (event.shiftKey) { // back tab
                if (focusedItemIndex == 0) { // first element focused -> focus the last element
                    focusableItems.get(focusableItems.length - 1).focus();
                    event.preventDefault();
                }
            } else { // forward tab
                if (focusedItemIndex == focusableItems.length - 1) { // last element focused -> focus the first element
                    focusableItems.get(0).focus();
                    event.preventDefault();
                }
            }
        }
    };
    $('body').on('keydown', '.aui-dialog, .aui-dialog2, .aui-inline-dialog', function(event) {
        trapTabKey($(this), event);
    });
    $(document).on('showLayer', function(e, name, dialog) { // for .aui-inline-dialog
        //no reset needed if the popup is a datepicker. see BFC-819
        if(dialog.element || (dialog.popup && !dialog.popup.hasClass("aui-datepicker-dialog")))
            apc.resetTabindex(dialog.element || dialog.popup);
    });
    AJS.bind('show.dialog', function(event, data) { // for .aui-dialog
        if (data.dialog && data.dialog.popup && data.dialog.popup.element) {
            apc.resetTabindex(data.dialog.popup.element);

            // BFC-652: make create space buttons tabable
            if (data.dialog.id === "create-dialog") {
                setInterval(function () {
                    $(data.dialog.popup.element).find("button.create-dialog-create-button").attr("tabindex", "0")
                }, 500);
                // really ugly fix for BFC-793 - but it works...Since Microsoft Edge has to be supported, we can't just
                // use .blur() after we focused the element with the tabindex of -1 because the bug would still be
                // existing in Edge then
                $(data.dialog.popup.element).find('[tabindex="-1"]').focus();
            }
        }
    });
    if (AJS.dialog2) { // is not available in the notification box iframe
        AJS.dialog2.on('show', function(event, dialog) { // for .aui-dialog2
            apc.resetTabindex(dialog);
        });
    }

    // fix manage watchers dialog
    AJS.$(document).on('list-updated.manage-watchers', function(e, data) {
        apc.resetTabindex($('#manage-watchers-dialog')); // add-watcher inputs, see https://jira.atlassian.com/browse/CONF-40895
        var $removeWatch = data.list.find('.remove-watch'); // trash icons
        apc.makeTabbable($removeWatch);
        apc.makeClickableViaKeyboard($removeWatch, {
            afterClickCallback: function() {
                // after removing a watcher with the keyboard, focus the add-watcher text input
                $('#manage-watchers-dialog #add-watcher-user').focus();
            }
        });

    });

    // set focus in an opened layer
    $(document).on('showLayer', function(e, name, dialog) {
        // apparently only "proper" dialogs have an element. we only want to handle those,
        // and no popups (e.g. search suggestions), which also fire a 'showLayer' event.
        if (dialog.element) {
            $('[tabindex]', dialog.element).removeProp('tabindex');
            $('.select2-choice, .dialog-panel-body, .space-select', dialog.element).attr("tabindex", "-1");
            dialog.element.find(apc.focusableElementsSelector).first().focus(); // default focus
            $(':input:first', dialog.element).focus(); // better focus the first input if there is one
            tabIndexReplace();
        }
        // there are also inline dialogs who have a "popup" variable, e.g. the watch dialog
        // not focus the dialog if the popup is a datepicker. see BFC-819
        else if (name == "inlineDialog" && dialog.popup && !dialog.popup.hasClass("aui-datepicker-dialog")) {
            dialog.popup.find(apc.focusableElementsSelector).first().focus();
        }
    });
    if (AJS.dialog2) { // is not available in the notification box iframe
        AJS.dialog2.on('show', function(event, dialog) {
            // jQuery's ":focusable" doesn't work for .aui-dialog2's. dunno why.
            dialog.find(apc.focusableElementsSelector).first().focus();
        });
    }

    // set focus on triggering element when closing a layer/dialog
    $(document).on("hideLayer", function(e, name, dialog) {
        if ($('.aui-dialog, .aui-dialog2').filter(':visible').length) {
            // there is another dialog open -> don't change focus
            return;
        }
        if (name == "inlineDialog") {
            if (dialog.id == "confluence-watch") {
                $('#watch-content-button').focus();
            } else if (dialog.id == "shareContentPopup") {
                $('#shareContentLink').focus();
            } else if (dialog.id == 'notifications-miniview') {
                $('#notifications-anchor').focus();
            }
        }
    });
    AJS.bind("hide.dialog remove.dialog", function(e, data) {
        if ($('.aui-dialog, .aui-dialog2').filter(':visible').length) {
            // there is another dialog open -> don't change focus
            return;
        }
        if (data.dialog) {
            if (data.dialog.id == "edit-labels-dialog") {
                //            on page view                 on edit view
                $('#labels-section .show-labels-editor, #rte-button-labels').focus();
            } else if (data.dialog.id == "move-page-dialog") {
                $('#rte-button-location').focus();
            } else if (data.dialog.id == "create-dialog") {
                // create-space button on dashboard
                $('#addSpaceLink').focus();
            }
        }
    });

    // re-set focus on favourite button after activating it
    $(document).on('blur', '#page-favourite', function(e) {
        // this is quite hacky: we want to focus() the favourite button when Confluence blur()s it. NOT when
        // the user tabs to the next element. in both cases a blur event is fired. we distinguish both cases
        // by the available data in the event:
        // if "originalEvent" is NOT present, then jQuery was not involved, which is the case when Confluence blur()s the button.
        if (!e.originalEvent) {
            var self = this;
            setTimeout(function() {
                AJS.$(self).focus();
            }, 0);
        }
    })

    // reset tab order
    $('#content.page.edit [tabindex]').removeProp('tabindex');
    
    // change tabindex after refresh of blueprint templates (according to its space choice)
    $(document).on("create-content.loaded", "#create-dialog", function() { $("ol.templates", $(this)).attr("tabindex", "0"); });

    // when content is added that should be tabbable but isn't, make it tabbable
    var makeTabbableObserver = new MutationObserver(function(mutations) {
        $.each(mutations, function(i, mutation) {
            apc.makeTabbable( $(mutation.target).find('a').not('[tabindex]') );
            var $removeRecipient = $(mutation.target).find('.remove-recipient')
            apc.makeTabbable($removeRecipient); // in share inline-dialog
            apc.makeClickableViaKeyboard($removeRecipient, {
                afterClickCallback: function() {
                    // after removing a share entry with the keyboard, focus the add text input
                    $('#inline-dialog-shareContentPopup #users').focus();
                }
            });
        });
    });
    makeTabbableObserver.observe(
        AJS.$('body')[0],
        { childList: true, subtree: true }
    );

    // notification box iframe
    var notificationContainer = AJS.$('#mw-container');
    if (notificationContainer.length && MW && MW.Notifications) {
        // see https://developer.mozilla.org/en-US/docs/Web/API/MutationObserver
        // works in IE10-, because Confluence already has a polyfill for it, yeah!
        var notificationObserver = new MutationObserver(function(mutations) {
            $.each(mutations, function(i, mutation) {
                $(mutation.target).find('.mw-notification-item')
                    .attr('tabindex', '0')
                    // we don't want to interfere with Confluence's key handling. so we don't listen to "keypress",
                    // but instead manually set the focused notification.
                    .off('focus.apc').on('focus.apc', function(event) {
                        var notification = MW.Notifications.getByAggregateKey( $(this).attr('aggregate-key') );
                        MW.Notifications.setFocused(notification);
                    })
                    .filter('.focused').focus();
                $(mutation.target).find('a.mw-drilldown-back') // back link
                    .attr('href', 'javascript:void(0)')
                    .focus();
            });
        });
        notificationObserver.observe(
            notificationContainer[0], // a node of the iframe which is always in the DOM
            { childList: true, subtree: true }
        );
    }

    // Confluence does not hide the space-favourite-add button in the page sidebar on page load, when it should.
    // we fix that.
    var spaceFavAdd = AJS.$('#space-favourite-add');
    if (spaceFavAdd.next('#space-favourite-remove:visible').length) {
        spaceFavAdd.hide();
    }

});

AJS.$(document).ready(function($) {
    // set active elements
    $('.profile-menu .aui-nav > li > a').each(function() {
        if (window.location.pathname == $(this).attr('href')) {
            $(this).addClass('active');
        }
    });
  
    // improve focusing of menu links
    $('body').keyup(function(e) {
        var code = e.keyCode || e.which;
        if (code == '9') {
            $('#admin-menu-link:focus, #user-menu-link:focus, #help-menu-link:focus').trigger('click');
        }
    });
});