/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.actions.UserAware;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbAware;
import com.atlassian.confluence.util.breadcrumbs.PeopleBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.UserBreadcrumb;
import com.atlassian.user.User;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

@AnonymousSiteAccess
public class EditScreenReaderModeAction
extends ConfluenceActionSupport
implements BreadcrumbAware,
UserAware {
    private static final Logger LOG = LoggerFactory.getLogger(EditScreenReaderModeAction.class);
    private APCUtils apcUtils;
    private PersonalInformationManager personalInformationManager;
    private ConfluenceUser user;
    private PersonalInformation personalInformationEntity;
    private boolean apcModeActive;
    private StrutsWrapper strutsWrapper;

    @PermittedMethods(value={HttpMethod.GET})
    public String editScreenReaderMode() {
        return "input";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doEditScreenReaderMode() {
        this.apcUtils.setAPCMode(this.getAuthenticatedUser(), this.strutsWrapper.getRequest().getSession(), this.apcModeActive);
        if (this.apcModeActive) {
            LOG.debug("Redirect to APC dashboard");
            return "apc";
        }
        return "input";
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)super.getWebInterfaceContext());
        result.setPersonalInformation(this.getPersonalInformationEntity());
        return result;
    }

    @Nullable
    public PersonalInformation getPersonalInformationEntity() {
        if (this.personalInformationEntity == null && this.getUser() != null) {
            this.personalInformationEntity = this.personalInformationManager.getOrCreatePersonalInformation((User)this.getUser());
        }
        return this.personalInformationEntity;
    }

    @Nullable
    public ConfluenceUser getUser() {
        if (this.user == null && StringUtils.isNotEmpty((CharSequence)this.getUsername())) {
            this.user = this.userAccessor.getUserByName(this.getUsername());
        }
        return this.user;
    }

    public String getPageTitle() {
        return this.getUser() != null ? this.getUser().getFullName() : "";
    }

    public String getUsername() {
        return this.getAuthenticatedUser() != null ? this.getAuthenticatedUser().getName() : null;
    }

    public boolean isUserRequired() {
        return false;
    }

    public boolean isViewPermissionRequired() {
        return false;
    }

    public boolean isMyProfile() {
        return this.getPersonalInformationEntity() != null && this.getPersonalInformationEntity().belongsTo((User)this.getAuthenticatedUser());
    }

    public Breadcrumb getBreadcrumb() {
        return this.getUser() != null ? new UserBreadcrumb((User)this.getUser()) : PeopleBreadcrumb.getInstance();
    }

    public boolean isApcModeActive() {
        return this.apcUtils.isAPCMode(this.getAuthenticatedUser(), this.strutsWrapper.getRequest().getSession());
    }

    @StrutsParameter
    public void setApcModeActive(boolean apcModeActive) {
        this.apcModeActive = apcModeActive;
    }

    public void setApcUtils(APCUtils apcUtils) {
        this.apcUtils = apcUtils;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

