AJS.toInit(function ($) {

    // relevant for user profile page
    var profileForm = $('div.page-item.profile-info > form'),
        upcActive = $('#upcPluginActive'),
        personalInformation = $('div.page-item.profile-info.section-3 > form > fieldset:nth-child(2)'),
        companyInformation = $('div.page-item.profile-info.section-3 > form > fieldset:nth-child(4)'),
        upcProfileUserInput = $('#upcProfileUser'),
        upcProfileUser;

    if (upcProfileUserInput.length)
        upcProfileUser = upcProfileUserInput.val() || AJS.params.remoteUser;

    if (profileForm.length && upcActive.length && personalInformation.length && companyInformation.length && upcProfileUser) {
        var urlUpcData = "/rest/communardo/upp/1.0/profileData/" + upcProfileUser + "?expand=profileData.profileElement";
        $.ajax({
            url: contextPath + urlUpcData,
            contentType: "application/json; charset=utf-8",
            success: function (data) {
                var editButtonsContainer = $('div.buttons-container');
                data.profileData.forEach(function (upe) {
                    if (!upe.profileElement.standard) {
                        var profileData;
                        if (editButtonsContainer.length) {
                            // following code is for edit profile
                            /*switch (upe.profileElement.elementType) {
                                case "USER_FIELD":
                                case "TEXT_FIELD":
                                    profileData += '<input id="' + upe.profileElement.defaultName + '" class="text" size="50" data-key="' + upe.profileElement.key + '" value="' + upe.data + '"/>';
                                    break;
                                case "SELECT_MULTIPLE":
                                    break;
                                case "SELECT_SINGLE":
                                    break;
                                case "USER_FIELD":
                                    profileData += '<input type="text" name="advanced-element-key-14" id="advanced-element-key-14" size="50" value="" class="text   autocomplete-user" data-autocomplete-user-or-group-bound="true" autocomplete="off" data-none-message="No users found">';
                                    break;
                            }
                            profileData = $('<div class="field-group viewMode"><label id="' + upe.profileElement.defaultName + '-label" for="' + upe.profileElement.defaultName + '">' + upe.profileElement.nameForCurrentLocale + '</label><input id="' + upe.profileElement.defaultName + '" class="text" size="50" data-key="' + upe.profileElement.key + '" value="' + upe.data + '"/></div>');*/
                        } else {
                            // following code is for view profile
                            var upeLabel = $('<label></label>');
                            upeLabel.text(upe.profileElement.nameForCurrentLocale);
                            upeLabel.attr('id', 'advanced-element-key-' + upe.profileElement.key + '-label');
                            upeLabel.attr('for', 'advanced-element-key-' + upe.profileElement.key);
                            var upeDataSpan = $('<span class="field-value">' + upe.data + '</span>');
                            upeDataSpan.attr('id', 'advanced-element-key-' + upe.profileElement.key);
                            profileData = $('<div class="field-group viewMode"></div>');
                            profileData.append(upeLabel, upeDataSpan);
                            if (upe.profileElement.profileGroup === "personal") {
                                personalInformation.append(profileData)
                            } else if (upe.profileElement.profileGroup === "business") {
                                companyInformation.append(profileData)
                            }
                        }
                    }
                });
            }
        });
    }

    //relevant for people directory
    var peopleList = $('#peoplelist'),
        tableHead = peopleList.find('thead > tr'),
        loadMoreButton = $('#apc-load-upc-data');
    if (peopleList.length && tableHead.length && loadMoreButton.length) {
        var customColumns = [],
            customColumnHeaderSet = false;

        loadMoreButton.click(function () {
            loadMoreButton.prop("disabled",true);
            // iterate over all user rows and add upc data
            $('tr[data-username]').each(function () {
                var upcUser = $(this).attr('data-username'),
                    urlUpcData = "/rest/communardo/upp/1.0/profileData/" + upcUser + "?expand=profileData.profileElement",
                    userRow = $(this);
                $.ajax({
                    url: contextPath + urlUpcData,
                    contentType: "application/json; charset=utf-8",
                    success: function (data) {
                        data.profileData.forEach(function (upe) {
                            if (upe.profileElement.displayInCustomMode) {
                                var upeTd = $('<td>' + upe.data + '</td>');
                                userRow.append(upeTd);
                            }
                            if (!customColumnHeaderSet && upe.profileElement.displayInCustomMode && customColumns.indexOf(upe.profileElement.nameForCurrentLocale) === -1)
                                customColumns.push(upe.profileElement.nameForCurrentLocale);
                        });
                        if (!customColumnHeaderSet) {
                            customColumns.forEach(function (value) {
                                var upeTh = $('<th/>');
                                upeTh.text(value);
                                tableHead.append(upeTh);
                            });
                            customColumnHeaderSet = true;
                        }
                    }
                });
            })
        })
    }
});