AJS.toInit(function ($) {
    // # following code is for sharepage.vm
    var Autocomplete = require('communardo/confluence/accessibility/autocomplete'),
        autocompleteGroupWidget = jQuery("[data-widget=accessible-autocomplete-groups]");
    if (autocompleteGroupWidget.length)
        Autocomplete.init(autocompleteGroupWidget[0]);

    var sharePageBtn = jQuery("#apcSubmitSharePage"),
        shareForm = jQuery('#apcFormSharePage'),
        sharePageId = jQuery('#apcsharepageid'),
        shareContentType = jQuery('#apcsharecontenttype'),
        shareNote = jQuery('#shareNote');

    if (sharePageBtn.length && shareForm.length && sharePageId.length && shareContentType.length && shareNote.length) {
        sharePageBtn.click(function () {
            var recipientList = jQuery('#recipientList').find('li');
            var users = [], emails = [], groups = [];
            recipientList.each(function (index, element) {
                var $element = jQuery(element);
                var elementType = $element.data("type");
                if (elementType === "user")
                    users.push($element.data('userKey'));
                else if (elementType === "group")
                    groups.push($element.data('value'));
                else if (elementType === "email")
                    emails.push($element.data('value'));
            });
            var sharePageUrl = contextPath + "/rest/share-page/latest/share";
            if (recipientList.length) {
                var shareData = {
                    contextualPageId: sharePageId.val(),
                    emails: emails,
                    entityId: sharePageId.val(),
                    entityType: shareContentType.val(),
                    groups: groups,
                    note: shareNote.val(),
                    users: users
                };
                $.ajax({
                    url: sharePageUrl,
                    type: "POST",
                    data: JSON.stringify(shareData),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (data) {
                        window.location.replace(contextPath + "/apc/pages/sharepagesuccess.action?pageId=" + sharePageId.val());
                    }
                });
            }
        });
    }
});