AJS.toInit(function($) {

    // comment textarea focusable
    $("form.quick-comment-form .quick-comment-prompt").attr("tabindex", "0");

    // remove some assistive elements for blind users
    $("label.assistive, span.assistive, a.assistive").remove();

    // BFC-283, BFC-494: search filters are not accessible
    $('#filter-form .aui-nav a').attr('href', 'javascript:void(0)'); // CF 5.8 and earlier
    $('#filter-form').on('cql-field-adding', function(event, fieldComponent) { // CF 5.9+
        fieldComponent.element.find('.aui-nav a').attr('href', 'javascript:void(0)'); // make filters focusable
        var $removeCqlFilterIcon = fieldComponent.element.find('.aui-icon.aui-iconfont-remove'); // remove-filter button
        apc.makeTabbable($removeCqlFilterIcon);
        apc.makeClickableViaKeyboard($removeCqlFilterIcon, {
                afterClickCallback: function() {
                    // after removing a filter with the keyboard, focus the add-filter button
                    $('#filter-form .cql-add-filter-container').find(apc.focusableElementsSelector).first().focus();
                }
            }
        );
    });
});