function stopEvent(e) {
    e = e || window.event; // for IE
    e.returnValue = false; // for IE<=8
    e.cancelBubble = true; // for IE<=8
    if (e.stopPropagation) e.stopPropagation();
    if (e.preventDefault) e.preventDefault();
    return false;
};

// compare the error message and set focus
AJS.bind('init.rte', function() {

    AJS.$('#content-title').prop('placeholder', AJS.$('#content-title').prop('placeholder') + ' (' + AJS.I18n.getText('required.field') + ')');

    if (!apc.isAtLeastConfluence57() || AJS.DarkFeatures.isEnabled("lighter-editor-v1-disable")) {
        // add text to label of title field in create/edit page/news form
        var titleLabel = $('#content-title-label');
        titleLabel.text(AJS.I18n.getText("title.name"));
        titleLabel.parent('.field-group').addClass('apc');
    }

    // collaborative editing is only in the old versions a dark feature
    // in the newer version it exist an AJS param for the editMode
    AJS.populateParameters();
    var isCollaborativeEditingEnabled = AJS.params.editMode !== undefined ? AJS.params.editMode === "collaborative" : AJS.DarkFeatures.isEnabled("collaborative.editing.frictionless.upgrade");

    if(apc.isAtLeastConfluence60() && isCollaborativeEditingEnabled) {
        // Maybe we should try to find another solution here then to use an interval to check if a specific button
        // is available in the page in the future. Question which maybe leads to goal in the future: Who adds the
        // inviteToEditLink button into the editor? On which event is this code listening?
        var tabableInviteLinkIntervalId = setInterval(function () {
            // BFC-652 BFC-800: make collaborative editing button tabable
            var $inviteToEditLink;
            $inviteToEditLink = AJS.$("#inviteToEditLink");
            if ($inviteToEditLink.length) {
                clearInterval(tabableInviteLinkIntervalId);
                apc.makeTabbable($inviteToEditLink);
            }
        }, 500);
    }

    AJS.$('#all-messages .error li').each(function() {
        if (AJS.$(this).html() == apc.scriptMessages.pageTitleEmpty) {
            setTimeout( function() { AJS.$('#content-title').focus(); }, 1000);
        }
    });

    // improve focusing of menu links
    AJS.$('body').keyup(function(e) {
        var code = e.keyCode || e.which;
        if (code == '9') {
            AJS.$('.apc-focus').removeClass('apc-focus');
            AJS.$(document.activeElement).parent('.toolbar-item').addClass('apc-focus');
        }
    });

    var editorContextSelector = '#comments-section, #content.edit';
    var editorFormsSelector = 'form.editor, form.quick-comment-form, form[name="editcommentform"], form[name="replycommentform"]';

    if (AJS.$(editorContextSelector).length) {
        // high-contrast mode for page, blogpost, and comment editor
        AJS.$(document).on('apc-hcm-changed', function(event, isHCM) {
            AJS.$(editorFormsSelector).toggleClass('apc-switch-editor-buttons', !!isHCM);
            AJS.$(window).trigger('resize'); // the toolbar is now probably higher -> redraw the editor
        });
        if (apc.hcm && apc.hcm.checkForHCM()) { // on init
            AJS.$(editorFormsSelector).addClass('apc-switch-editor-buttons');
            AJS.$(window).trigger('resize'); // the toolbar is now probably higher -> redraw the editor
        }

        // for correct focusing hide or show preview or edit button
        var isRichtext = true;
        function setEditorMode() {
            AJS.$('#rte-button-edit').toggle(!isRichtext);
            AJS.$('#rte-button-preview').toggle(isRichtext);
            isRichtext = !isRichtext;
        }
        setEditorMode();
        AJS.$('#rte-button-preview, #rte-button-edit').click(setEditorMode);
    }

    function removeTabindex() {
        var itemsWithTabIndex;
        if (AJS.$('#wysiwygTextarea_ifr').length) {
            itemsWithTabIndex = AJS.$(editorContextSelector).find('[tabindex]');
            itemsWithTabIndex.each(function(index) {
                var element = AJS.$(this);
                // don't remove elements with attr tabindex = 0 because it doesn't change the tab order
                // also don't remove elements with tabindex = "0"
                if (element.attr("tabindex") !== 0 && element.attr("tabindex") !== "0") {
                    element.removeAttr('tabindex');
                }
            });
            return false;
        }
    }
    setInterval(removeTabindex, 3000);


    // save current color as data-attribute for HCM, for display via CSS
    AJS.$('#color-picker-control').on('click', '.color-picker a', function() {
        var colorButton = AJS.$(this);
        if (!colorButton.closest('.disabled').length) {
            AJS.$('#rte-button-color .selected-color').attr( 'data-color', colorButton.attr('data-color') );
        }
    });
    AJS.$('#rte-button-color .selected-color').attr( 'data-color', AJS.$('#rte-button-color').attr('data-color') );

});

AJS.toInit(function($) {
    $('div.quick-comment-prompt')
        .prop('tabindex', '0') // make comment editor focusable
        .keypress(function(event) { // call the editor, if you press enter in the comment field
            if (event.which == 13) {
                stopEvent(event);
                $(this).trigger('click');
            }
        });
});
