AJS.toInit(function ($) {
    const attachmentFilenameLinkSelector = '#apc-attachments-table a.filename';

    function rewriteFilenameLinkTarget(layoutCellId) {
        $(attachmentFilenameLinkSelector).attr("href",'#' + layoutCellId);
    }

    function writeAttachmentLinkToLayoutCell(filename, layoutCellId) {
        var textarea = $(layoutCellId);
        var wikilink = $('meta[name="wikilink"]').attr('content');

        filename = wikilink.substring(0, wikilink.length - 1) + '^' + filename + ']';
        textarea.val(textarea.val() + filename);
    }

    if ($('#content.edit').length) {
        $('.apc-add-attachment-link').click(function (e){
            $("#attachment-section").removeClass("hidden");
            const cellId = e.target.getAttribute('data-cell-id');
            rewriteFilenameLinkTarget(cellId);
        });
        $(attachmentFilenameLinkSelector).click(function (e) {
            $("#attachment-section").addClass("hidden");
            var filename = $(this).attr('title');
            var cellId = $(this).attr("href");
            writeAttachmentLinkToLayoutCell(filename, cellId);
        });
    }
});