/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.util;

import de.communardo.confluence.plugins.apc.util.LayoutCell;
import java.util.ArrayList;
import java.util.List;

public class ContentRepresentation {
    private final List<LayoutCell> layoutCells = new ArrayList<LayoutCell>();
    private String storageFormatWithPlaceholders;
    private static final int NO_LAYOUT_CELL_ID = 0;

    private ContentRepresentation() {
    }

    public static ContentRepresentation createWithLayout(List<LayoutCell> layoutCells, String storageFormatWithPlaceholders) {
        ContentRepresentation contentRepresentation = new ContentRepresentation();
        contentRepresentation.layoutCells.addAll(layoutCells);
        contentRepresentation.storageFormatWithPlaceholders = storageFormatWithPlaceholders;
        return contentRepresentation;
    }

    public static ContentRepresentation createWithoutLayout(String wikiMarkup) {
        ContentRepresentation contentRepresentation = new ContentRepresentation();
        contentRepresentation.layoutCells.add(new LayoutCell(0, wikiMarkup));
        return contentRepresentation;
    }

    public List<LayoutCell> getLayoutCells() {
        return this.layoutCells;
    }

    public String getStorageFormatWithPlaceholders() {
        return this.storageFormatWithPlaceholders;
    }

    public boolean hasLayout() {
        return this.storageFormatWithPlaceholders != null;
    }
}

