/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.service;

import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import de.communardo.confluence.plugins.apc.util.PlaceholderUtils;
import de.communardo.confluence.plugins.apc.util.SFtoWMTransformer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class CommentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommentService.class);
    private final PlaceholderUtils placeholderUtils;
    private final SFtoWMTransformer theSFtoWMTransformer;

    public CommentService(PlaceholderUtils placeholderUtils, SFtoWMTransformer theSFtoWMTransformer) {
        this.placeholderUtils = placeholderUtils;
        this.theSFtoWMTransformer = theSFtoWMTransformer;
    }

    private void storeCommentObject(Comment comment, Map<Integer, Node> nonEditableElements) {
        HashMap<String, Object> commentMap = new HashMap<String, Object>();
        commentMap.put("content.id", comment.getId());
        commentMap.put("non_editable.elements", nonEditableElements);
        this.placeholderUtils.setObject(comment.getId(), commentMap);
    }

    public void removeComment(long id) {
        this.placeholderUtils.removeObject(id);
    }

    public String getAPCWikiMarkupContent(Comment comment) {
        ContentRepresentation contentRepresentation = null;
        if (comment != null && comment.getBodyContent().getBodyType() == BodyType.XHTML) {
            SFtoWMTransformer.TransformResult transformResult;
            ContentEntityObject container = comment.getContainer();
            if (container instanceof AbstractPage) {
                transformResult = this.theSFtoWMTransformer.transform(comment.getBodyAsString(), (AbstractPage)container);
            } else {
                LOGGER.info("comment {}'s container is a '{}', but expected an AbstractPage.", (Object)comment.getId(), container != null ? container.getClass() : "null");
                transformResult = this.theSFtoWMTransformer.transform(comment.getBodyAsString());
            }
            contentRepresentation = transformResult.getContentRepresentation();
            if (contentRepresentation != null) {
                this.storeCommentObject(comment, transformResult.getNonTransformableElements());
            } else {
                LOGGER.debug("cannot transform comment with id {} to wiki-markup.", (Object)comment.getId());
            }
        } else {
            LOGGER.debug("cannot transform comment {} to wiki-markup because it neither exists nor contains XHTML.", (Object)comment);
        }
        return contentRepresentation != null && !contentRepresentation.hasLayout() ? contentRepresentation.getLayoutCells().get(0).getWikiMarkup() : null;
    }
}

