/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.macro.recentlyupdated;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import de.communardo.confluence.plugins.apc.license.APCLicenseService;
import de.communardo.confluence.plugins.apc.macro.recentlycontent.search.RecentlyContentSearcher;
import java.util.Map;

public class RecentlyContentMacro
extends BaseMacro
implements Macro {
    private final RecentlyContentSearcher recentlyContentSearcher;
    private final APCLicenseService apcLicenseService;
    private final VelocityHelperService velocityHelperService;

    public RecentlyContentMacro(RecentlyContentSearcher recentlyContentSearcher, APCLicenseService apcLicenseService, VelocityHelperService velocityHelperService) {
        this.recentlyContentSearcher = recentlyContentSearcher;
        this.apcLicenseService = apcLicenseService;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            return this.execute(parameters, body, context != null ? context.getRenderContext() : null);
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public String execute(Map parameter, String body, RenderContext renderContext) throws MacroException {
        if (!this.apcLicenseService.isValidLicense()) {
            throw new MacroException(GeneralUtil.getI18n().getText("de.communardo.confluence.plugins.apc.license.invalid"));
        }
        boolean searchBlogPosts = Boolean.parseBoolean((String)parameter.get("searchBlogPosts"));
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("recentlyContent", this.recentlyContentSearcher.findRecentlyContent(searchBlogPosts));
        contextMap.put("searchBlogPosts", searchBlogPosts);
        return this.velocityHelperService.getRenderedTemplate("/vm/macro/recentlycontent/recentlycontent.vm", contextMap);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }
}

