/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.macro.recentlycontent.search;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilderFactory;
import de.communardo.confluence.plugins.apc.macro.recentlycontent.search.RecentlyContentSearchBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentlyContentSearcher {
    private static final Logger log = LoggerFactory.getLogger(RecentlyContentSearcher.class);
    private final SearchManager searchManager;
    private final RecentlyContentSearchBuilder recentlyContentSearchBuilder;

    public RecentlyContentSearcher(SearchManager searchManager, ContentSearchBuilderFactory contentSearchBuilderFactory) {
        this.searchManager = searchManager;
        this.recentlyContentSearchBuilder = new RecentlyContentSearchBuilder(contentSearchBuilderFactory);
    }

    public List<AbstractPage> findRecentlyContent(boolean searchBlogPosts) {
        try {
            ISearch search = this.recentlyContentSearchBuilder.getRecentlyContentSearch(searchBlogPosts);
            if (search != null) {
                SearchResults searchResults = this.searchManager.search(search);
                return this.searchManager.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION).stream().map(searchable -> (AbstractPage)searchable).toList();
            }
            return null;
        }
        catch (Exception e) {
            log.error("Exception occurred during blogpost search", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

