/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.macro.recentlycontent.search;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.macro.query.BooleanQueryFactory;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.spring.container.ContainerManager;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilder;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilderFactory;

public class RecentlyContentSearchBuilder {
    private static final int LAST_RECENTLY_CONTENT_SEARCH_LIMIT = 5;
    private final ContentSearchBuilderFactory contentSearchBuilderFactory;

    public RecentlyContentSearchBuilder(ContentSearchBuilderFactory contentSearchBuilderFactory) {
        this.contentSearchBuilderFactory = contentSearchBuilderFactory;
    }

    public ISearch getRecentlyContentSearch(boolean searchBlogPost) {
        BooleanQueryFactory query = new BooleanQueryFactory();
        query.addMust((SearchQuery)new ContentTypeQuery(searchBlogPost ? ContentTypeEnum.BLOG : ContentTypeEnum.PAGE));
        query.addMust((SearchQuery)new SpaceCategoryQuery(SpaceCategoryEnum.ALL, (LabelManager)ContainerManager.getComponent((String)"labelManager", LabelManager.class)));
        CreatedSort searchSort = new CreatedSort(SearchSort.Order.DESCENDING);
        ContentSearchBuilder contentSearchBuilder = this.contentSearchBuilderFactory.createContentSearchBuilder();
        return contentSearchBuilder.addMustQuery((SearchQuery)query.toBooleanQuery()).setUseSiteSearchPermissionFilter(true).setStartOffset(0).setLimit(5).setSort((SearchSort)searchSort).createSiteSearch();
    }
}

