/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.listener;

import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.LoginRequestThreadLocal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.DisposableBean;

public class LoginEventListener
implements DisposableBean {
    private final APCUtils apcUtils;
    private final UserAccessor userAccessor;
    private final EventPublisher eventPublisher;

    public LoginEventListener(APCUtils apcUtils, UserAccessor userAccessor, EventPublisher eventPublisher) {
        this.apcUtils = apcUtils;
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void handleLoginEvent(LoginEvent event) {
        HttpSession session;
        HttpServletRequest request;
        ConfluenceUser user = this.userAccessor.getUserByName(event.getUsername());
        if (user != null && (request = LoginRequestThreadLocal.getRequest()) != null && (session = request.getSession()) != null) {
            String apcLoginMode = request.getParameter("apc_login_mode");
            this.apcUtils.setAPCMode(user, session, apcLoginMode != null && apcLoginMode.equals("on"));
        }
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

