/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.compatibility.search;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.spring.container.ContainerManager;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryParameterWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SearchQueryParameterWrapper.class);

    private SearchQueryParameterWrapper() {
    }

    public static SearchQuery toSearchV2Query(SearchQueryParameters searchQueryParameters, Map<String, String> extraParams) throws Exception {
        Method convertMethod = SearchQueryParameterWrapper.findMethodByName(searchQueryParameters.getClass(), "toSearchV2Query");
        if (convertMethod.getParameters().length > 1) {
            LabelManager labelManager = (LabelManager)ContainerManager.getComponent((String)"labelManager", LabelManager.class);
            ConfluenceUserDao confluenceUserDao = (ConfluenceUserDao)ContainerManager.getComponent((String)"confluenceUserDao", ConfluenceUserDao.class);
            return (SearchQuery)convertMethod.invoke((Object)searchQueryParameters, extraParams, labelManager, confluenceUserDao);
        }
        return (SearchQuery)convertMethod.invoke((Object)searchQueryParameters, extraParams);
    }

    private static Method findMethodByName(Class<?> clazz, String methodName) throws IllegalAccessException {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (StringUtils.compare((String)method.getName(), (String)methodName) != 0) continue;
            return method;
        }
        throw new IllegalAccessException("Requested method could not be found.");
    }
}

