/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action.favourite;

import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.service.AddLabelsCommand;
import com.atlassian.confluence.labels.service.LabelsService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class APCAddFavouriteAction
extends ConfluenceActionSupport {
    private LabelsService labelsService;
    private SpaceService spaceService;
    private String contentId;
    private String contentType;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && StringUtils.isNotBlank((CharSequence)this.contentType) && StringUtils.isNotBlank((CharSequence)this.contentId)) {
            if (this.contentType.equals("space")) {
                Label label = new Label("favourite", Namespace.PERSONAL, user);
                Space space = this.spaceService.getKeySpaceLocator(this.contentId).getSpace();
                if (space != null) {
                    this.labelManager.addLabel((Labelable)space.getDescription(), label);
                }
            } else {
                Label favouriteLabel = new Label("favourite", Namespace.PERSONAL, user);
                String labelString = favouriteLabel.toStringWithNamespace();
                if (!this.runCommand(this.labelsService.newAddLabelCommand(labelString, (User)user, Long.parseLong(this.contentId)))) {
                    return "error";
                }
            }
        }
        return "success";
    }

    private boolean runCommand(AddLabelsCommand command) {
        if (!command.isValid()) {
            for (ValidationError error : command.getValidationErrors()) {
                this.addActionError(error.getMessageKey(), error.getArgs());
            }
            return false;
        }
        command.execute();
        return true;
    }

    @StrutsParameter
    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getContentId() {
        return this.contentId;
    }

    @StrutsParameter
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setLabelsService(LabelsService labelsService) {
        this.labelsService = labelsService;
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }
}

