/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action.ImportedClasses;

import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.search.plugin.ContentTypeSearchDescriptor;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.DateRangeEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ImportedSearchActionParameterMigrator {
    private final Function<SearchQueryParameters, String> convertToTextField = s -> StringUtils.isBlank((CharSequence)s.getQuery()) ? null : "siteSearch ~ " + this.quote(s.getQuery());
    private final Function<SearchQueryParameters, String> convertToSpaceField = s -> StringUtils.isBlank((CharSequence)s.getSpaceKey()) ? null : "space = " + this.quote(s.getSpaceKey());
    private final Function<SearchQueryParameters, String> convertToSpaceTypeField = s -> {
        String spaceType;
        if (s.getSpaceCategory() == null) {
            return null;
        }
        switch (s.getSpaceCategory()) {
            case GLOBAL: {
                spaceType = "global";
                break;
            }
            case PERSONAL: {
                spaceType = "personal";
                break;
            }
            case FAVOURITES: {
                spaceType = "favourite";
                break;
            }
            case ALL: {
                return null;
            }
            default: {
                throw new NotImplementedServiceException("Space category type not implemented: " + s.getSpaceCategory());
            }
        }
        return "space.type = \"" + spaceType + "\"";
    };
    private final Function<SearchQueryParameters, String> convertToTypeField = s -> {
        ContentTypeEnum contentType = s.getContentType();
        if (contentType == null) {
            ContentTypeSearchDescriptor pluginContentType = s.getPluginContentType();
            return pluginContentType != null ? "type = " + this.quote(pluginContentType.getIdentifier()) : null;
        }
        String typeStr = contentType != ContentTypeEnum.SPACE_DESCRIPTION && contentType != ContentTypeEnum.PERSONAL_SPACE_DESCRIPTION ? (contentType == ContentTypeEnum.PERSONAL_INFORMATION ? "user" : contentType.toString()) : "space";
        return "type = " + this.quote(typeStr);
    };
    private final Function<SearchQueryParameters, String> convertToLastModifiedField = s -> {
        if (s.getLastModified() == null) {
            return null;
        }
        String nowFunctionArgument = switch (s.getLastModified()) {
            default -> throw new IncompatibleClassChangeError();
            case DateRangeEnum.LASTDAY -> "-1d";
            case DateRangeEnum.LASTTWODAYS -> "-2d";
            case DateRangeEnum.LASTWEEK -> "-1w";
            case DateRangeEnum.LASTMONTH -> "-1M";
            case DateRangeEnum.LASTSIXMONTHS -> "-6M";
            case DateRangeEnum.LASTYEAR -> "-1y";
            case DateRangeEnum.LASTTWOYEARS -> "-2y";
        };
        return "lastmodified >= now('" + nowFunctionArgument + "')";
    };
    private final Function<SearchQueryParameters, String> convertToContributorField = s -> s.getContributor() == null ? null : "contributor = " + this.quote(s.getContributor());
    private final Function<SearchQueryParameters, String> convertToLabelsField = s -> {
        Set labels = s.getLabels();
        return labels != null && !labels.isEmpty() ? labels.stream().filter(StringUtils::isNotBlank).map(label -> "label = \"" + label + "\"").collect(Collectors.joining(" AND ")) : null;
    };

    private ImportedSearchActionParameterMigrator() {
    }

    private String quote(String stringToQuote) {
        return "\"" + stringToQuote.replaceAll("\"", "\\\\\"") + "\"";
    }

    public static String migrate(SearchQueryParameters searchQueryParameters) {
        ImportedSearchActionParameterMigrator searchActionParameterMigrator = new ImportedSearchActionParameterMigrator();
        List<Function> parameterConverters = Arrays.asList(searchActionParameterMigrator.convertToTextField, searchActionParameterMigrator.convertToSpaceField, searchActionParameterMigrator.convertToSpaceTypeField, searchActionParameterMigrator.convertToTypeField, searchActionParameterMigrator.convertToLastModifiedField, searchActionParameterMigrator.convertToContributorField, searchActionParameterMigrator.convertToLabelsField);
        return parameterConverters.stream().map(f -> (String)f.apply(searchQueryParameters)).filter(Objects::nonNull).collect(Collectors.joining(" AND "));
    }
}

