/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.pages.actions.EditBlogPostAction;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;

@AnonymousSiteAccess
public class APCEditBlogPostAction
extends EditBlogPostAction {
    private APCUtils apcUtils;
    private ContentRepresentation contentRepresentation;
    private String unexpectedError;
    private StrutsWrapper strutsWrapper;

    public void validate() {
        long id = Long.parseLong(this.strutsWrapper.getValueForRequestParameter("pageId"));
        this.contentRepresentation = this.apcUtils.getContentRepresentationFromRequestParameters(this.strutsWrapper.getParameterMap());
        if (this.contentRepresentation != null) {
            super.setWysiwygContent(this.apcUtils.convertWikiMarkupToWysiwyg(this.contentRepresentation, id));
        }
        super.validate();
    }

    public String doEdit() {
        if (this.contentRepresentation == null) {
            this.unexpectedError = this.getText("de.communardo.confluence.plugins.apc.messages.edit.save.unexpected-error");
            return "error";
        }
        return super.doEdit();
    }

    public String getUnexpectedError() {
        return this.unexpectedError;
    }

    public void setApcUtils(APCUtils apcUtils) {
        this.apcUtils = apcUtils;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

