AJS.toInit(function($) {
	// remove invalid shortcut documentation from shortcuts help view
    $(document).bind('showLayer', function(e, name, dialog) {
        if (dialog && dialog.element && dialog.element.attr('id') == 'keyboard-shortcuts-dialog') {
            $('.shortcutsmenu').each(function() {
                $(this).find('.regular-key').each(function() {
                    var regularKey = $(this);
                    if ($.trim(regularKey.text()) == '/') {
                        regularKey.closest('.item-details').remove();
                    }
                });
            });
        }
        
        if (dialog && dialog.element && dialog.element.attr('id') == 'create-dialog') {
			// BFC-388 - suppress creation of page after pressing the "enter" key for specific input fields
			dialog.element.on("keydown", function(event) {
				if(event.keyCode == 13 && !$(event.target).hasClass("create-dialog-create-button")) {
					event.stopPropagation();

					if(event.target.id == "createDialogFilter") {
						return false;
					}					
				}		
			});
		}
	});
    
    var removeUnderline = function(elem) {
    	if (elem !== undefined && elem.html !== undefined && elem.html() !== undefined) {
    		elem.html(elem.html().replace("<u>", "").replace("</u>", ""));
    	}
    	return elem;
    }

    // BFC-556 add shortcuts to buttons on a page
    removeUnderline($("#editPageLink")).append("(<u>e</u>)");
    $("#watch-content-button").append("(<u>w</u>)");
    removeUnderline($("#shareContentLink")).append("(<u>s</u>)");

    // BFC-554 dialog focus resolved comments
    if(Backbone !== undefined) {
	    Backbone.listenTo(Backbone, "ic:resolved:view", function (totalResolvedComments) {
	    	if(AJS.$("#ic-resolved-comment-dialog").length > 0) {
	            AJS.$("#ic-resolved-comment-dialog .ic-author .confluence-userlink").attr("tabindex", 0).focus();
	        }
	    });
    }
    
});