/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.shared;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import de.communardo.shared.LicenseState;
import de.communardo.shared.LongKeyHasher;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseStateRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseStateRepository.class);
    private final PluginSettings pluginSettings;

    @Inject
    @Autowired
    public LicenseStateRepository(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    Optional<LicenseState> load(String appKey) {
        String startDateStr = (String)this.pluginSettings.get(LicenseStateRepository.getAppStartDateStorageKey(appKey));
        if (startDateStr != null) {
            try {
                byte[] decodedStartDate = Base64.getDecoder().decode(startDateStr);
                Date startDate = new Date(ByteBuffer.wrap(decodedStartDate).getLong());
                String hashesStr = (String)this.pluginSettings.get(LicenseStateRepository.getAppHashesStorageKey(appKey));
                List<String> hashes = LicenseStateRepository.parseHashesStorage(hashesStr);
                return Optional.of(new LicenseState(hashes, startDate));
            }
            catch (Exception e) {
                log.debug("Failed to parse license state", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    void store(String appKey, LicenseState licenseState) {
        try {
            String base64StartDate = LicenseStateRepository.generateStartDateStorage(licenseState);
            this.pluginSettings.put(LicenseStateRepository.getAppStartDateStorageKey(appKey), (Object)base64StartDate);
            String base64Hashes = LicenseStateRepository.generateHashesStorage(licenseState);
            this.pluginSettings.put(LicenseStateRepository.getAppHashesStorageKey(appKey), (Object)base64Hashes);
        }
        catch (Exception e) {
            log.debug("Could not store license state: {}", (Object)licenseState);
            log.debug("", (Throwable)e);
        }
    }

    void remove(String appKey) {
        this.pluginSettings.remove(LicenseStateRepository.getAppStartDateStorageKey(appKey));
        this.pluginSettings.remove(LicenseStateRepository.getAppHashesStorageKey(appKey));
    }

    static String generateStartDateStorage(LicenseState licenseState) {
        return Base64.getEncoder().encodeToString(ByteBuffer.allocate(8).putLong(licenseState.getStartDate().getTime()).array());
    }

    static String generateHashesStorage(LicenseState licenseState) {
        return Base64.getEncoder().encodeToString(String.join((CharSequence)",", licenseState.getLicenses()).getBytes(StandardCharsets.UTF_8));
    }

    private static List<String> parseHashesStorage(String hashesStorage) {
        byte[] decodedHashes = Base64.getDecoder().decode(hashesStorage);
        return Arrays.asList(new String(decodedHashes).split(","));
    }

    private static String getAppStartDateStorageKey(String appKey) {
        return LongKeyHasher.hashKeyIfTooLong("com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:" + appKey + ":communardo-check:start");
    }

    private static String getAppHashesStorageKey(String appKey) {
        return LongKeyHasher.hashKeyIfTooLong("com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:" + appKey + ":communardo-check:hashes");
    }

    @Generated
    public LicenseStateRepository(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

