/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.util;

import com.atlassian.confluence.content.render.xhtml.model.inline.Emoticon;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xml.XhtmlEntityResolver;
import com.atlassian.sal.api.user.UserKey;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import de.communardo.confluence.plugins.apc.util.LayoutCell;
import de.communardo.confluence.plugins.apc.util.XmlUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.dom.DeferredElementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SFtoWMTransformer {
    public static final List<String> NON_TRANSFORMABLE_MACROS = Arrays.asList("content-report-table", "create-from-template", "profile-picture", "jirachart", "roadmap", "tasks-report-macro");
    private static final Logger LOGGER = LoggerFactory.getLogger(SFtoWMTransformer.class);
    private static final String NEW_LINE = System.lineSeparator();
    private static final String SPACE = " ";
    private static final Map<String, String> WIKI_EMOTICONS = new HashMap<String, String>(25);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private static final XhtmlEntityResolver XHTML_ENTITY_RESOLVER;
    private UserAccessor userAccessor;

    public SFtoWMTransformer(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public TransformResult transform(@Nonnull AbstractPage abstractPage) {
        return this.transform(abstractPage.getBodyAsString(), abstractPage);
    }

    public TransformResult transform(String storageFormat) {
        return this.transform(storageFormat, (AbstractPage)null);
    }

    public TransformResult transform(String storageFormat, @Nullable AbstractPage relatedAbstractPage) {
        return this.transform(storageFormat, new Worker(relatedAbstractPage));
    }

    @Nonnull
    private TransformResult transform(String storageFormat, Worker worker) {
        TransformResult transformResult = new TransformResult();
        ContentRepresentation contentRepresentation = worker.transform(storageFormat);
        if (contentRepresentation != null) {
            transformResult.setContentRepresentation(contentRepresentation);
            transformResult.setNonTransformableElements(worker.getNonTransformableElements());
        }
        return transformResult;
    }

    static {
        WIKI_EMOTICONS.put(Emoticon.SMILE.getType(), ":-)");
        WIKI_EMOTICONS.put(Emoticon.SMILE.getType(), ":)");
        WIKI_EMOTICONS.put(Emoticon.CHEEKY.getType(), ":P");
        WIKI_EMOTICONS.put(Emoticon.CHEEKY.getType(), ":p");
        WIKI_EMOTICONS.put(Emoticon.WINK.getType(), ";-)");
        WIKI_EMOTICONS.put(Emoticon.WINK.getType(), ";)");
        WIKI_EMOTICONS.put(Emoticon.LAUGH.getType(), ":D");
        WIKI_EMOTICONS.put(Emoticon.SAD.getType(), ":-(");
        WIKI_EMOTICONS.put(Emoticon.SAD.getType(), ":(");
        WIKI_EMOTICONS.put(Emoticon.THUMBS_UP.getType(), "(y)");
        WIKI_EMOTICONS.put(Emoticon.THUMBS_DOWN.getType(), "(n)");
        WIKI_EMOTICONS.put(Emoticon.INFORMATION.getType(), "(i)");
        WIKI_EMOTICONS.put(Emoticon.TICK.getType(), "(/)");
        WIKI_EMOTICONS.put(Emoticon.CROSS.getType(), "(x)");
        WIKI_EMOTICONS.put(Emoticon.PLUS.getType(), "(+)");
        WIKI_EMOTICONS.put(Emoticon.MINUS.getType(), "(-)");
        WIKI_EMOTICONS.put(Emoticon.WARNING.getType(), "(!)");
        WIKI_EMOTICONS.put(Emoticon.QUESTION.getType(), "(?)");
        WIKI_EMOTICONS.put(Emoticon.LIGHT_ON.getType(), "(on)");
        WIKI_EMOTICONS.put(Emoticon.LIGHT_OFF.getType(), "(off)");
        WIKI_EMOTICONS.put(Emoticon.YELLOW_STAR.getType(), "(*)");
        WIKI_EMOTICONS.put(Emoticon.BLUE_STAR.getType(), "(*b)");
        WIKI_EMOTICONS.put(Emoticon.YELLOW_STAR.getType(), "(*y)");
        WIKI_EMOTICONS.put(Emoticon.GREEN_STAR.getType(), "(*g)");
        WIKI_EMOTICONS.put(Emoticon.RED_STAR.getType(), "(*r)");
        DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        DOCUMENT_BUILDER_FACTORY.setValidating(false);
        DOCUMENT_BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
        XHTML_ENTITY_RESOLVER = new XhtmlEntityResolver();
    }

    private class Worker {
        @Nullable
        private final AbstractPage relatedAbstractPage;
        private BlockNodeTransformer blockNodeTransformer = new BlockNodeTransformer();
        private ListNodeTransformer listNodeTransformer = new ListNodeTransformer();
        private Map<Integer, Node> nonTransformableElements = new HashMap<Integer, Node>();
        private Integer nonTransformableNodeId = 0;

        public Worker(AbstractPage relatedAbstractPage) {
            this.relatedAbstractPage = relatedAbstractPage;
        }

        public ContentRepresentation transform(String storageFormat) {
            String wikiMarkup = "";
            try {
                if (storageFormat.isEmpty()) {
                    return ContentRepresentation.createWithoutLayout(wikiMarkup);
                }
                DocumentBuilder dBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
                dBuilder.setEntityResolver((EntityResolver)XHTML_ENTITY_RESOLVER);
                String storageFormatXML = "<!DOCTYPE xhtml [" + XHTML_ENTITY_RESOLVER.createDTD() + "]><root>" + storageFormat + "</root>";
                Document doc = dBuilder.parse(new InputSource(new StringReader(storageFormatXML)));
                Element documentElement = doc.getDocumentElement();
                documentElement.normalize();
                return this.transformLayout(documentElement);
            }
            catch (IOException | NullPointerException | ParserConfigurationException | SAXException e) {
                LOGGER.error(e.toString());
                return null;
            }
        }

        private ContentRepresentation transformLayout(Element documentElement) {
            ContentRepresentation contentRepresentation = null;
            Node node = documentElement.getFirstChild();
            if (node.getNodeName().equals("ac:layout")) {
                ArrayList<LayoutCell> layoutCells = new ArrayList<LayoutCell>();
                for (Node layoutSectionNode : XmlUtil.asList(node.getChildNodes())) {
                    for (Node layoutCellNode : XmlUtil.asList(layoutSectionNode.getChildNodes())) {
                        LayoutCell layoutCell = this.extractCellAndAddPlaceholderToTheNode(layoutCellNode);
                        layoutCells.add(layoutCell);
                    }
                }
                String storageFormatWithPlaceholders = this.nodeToString(node);
                contentRepresentation = ContentRepresentation.createWithLayout(layoutCells, storageFormatWithPlaceholders);
            } else {
                String wikiMarkup = this.extractWikiMarkup(documentElement);
                contentRepresentation = ContentRepresentation.createWithoutLayout(wikiMarkup);
            }
            return contentRepresentation;
        }

        private LayoutCell extractCellAndAddPlaceholderToTheNode(Node node) {
            int nodeIndex = ((DeferredElementImpl)node).getNodeIndex();
            String wikiMarkup = this.extractWikiMarkup(node);
            LayoutCell layoutCell = new LayoutCell(nodeIndex, wikiMarkup);
            node.setTextContent("placeholder-" + nodeIndex);
            return layoutCell;
        }

        private String extractWikiMarkup(Node node) {
            String wikiMarkup = "";
            for (Node layoutChildCellNode : XmlUtil.asList(node.getChildNodes())) {
                wikiMarkup = wikiMarkup + this.transformNode(layoutChildCellNode);
            }
            wikiMarkup = this.sanitizeWikiMarkup(wikiMarkup);
            return wikiMarkup;
        }

        private String sanitizeWikiMarkup(String wikiMarkup) {
            wikiMarkup = wikiMarkup.replaceAll("\\t", "");
            wikiMarkup = this.contractSpaces(wikiMarkup);
            wikiMarkup = this.contractNewlines(wikiMarkup);
            return wikiMarkup;
        }

        private String nodeToString(Node node) {
            Document document = node.getOwnerDocument();
            DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
            LSSerializer serializer = domImplLS.createLSSerializer();
            String serializedNode = serializer.writeToString(node);
            serializedNode = serializedNode.substring(serializedNode.indexOf(">") + 1);
            return serializedNode;
        }

        public Map<Integer, Node> getNonTransformableElements() {
            return this.nonTransformableElements.isEmpty() ? null : this.nonTransformableElements;
        }

        private String transformNode(Node nodeToTransform) {
            return this.transformNode(nodeToTransform, "");
        }

        private String transformNode(Node nodeToTransform, String wiki) {
            try {
                if (this.hasParentWithSameName(nodeToTransform).booleanValue()) {
                    throw new NonTransformableNodeException(nodeToTransform);
                }
                if (nodeToTransform.getNodeType() == 3) {
                    return this.transformText(nodeToTransform);
                }
                if (nodeToTransform.getNodeType() == 1) {
                    String nodeName;
                    switch (nodeName = nodeToTransform.getNodeName()) {
                        case "ac:structured-macro": {
                            return this.transformMacro(nodeToTransform);
                        }
                        case "table": {
                            return this.transformTable(nodeToTransform);
                        }
                        case "ac:link": {
                            return this.transformStorageLink(nodeToTransform, false);
                        }
                        case "ac:image": {
                            return this.transformImage(nodeToTransform);
                        }
                        case "br": {
                            return this.transformVoidElement(nodeToTransform, wiki);
                        }
                        case "hr": {
                            return this.transformVoidElement(nodeToTransform, wiki);
                        }
                        case "b": 
                        case "strong": 
                        case "p": 
                        case "em": 
                        case "blockquote": 
                        case "i": 
                        case "s": 
                        case "del": 
                        case "u": 
                        case "sup": 
                        case "sub": 
                        case "cite": 
                        case "code": {
                            return this.blockNodeTransformer.transformNode(nodeToTransform, wiki);
                        }
                        case "h1": 
                        case "h2": 
                        case "h3": 
                        case "h4": 
                        case "h5": 
                        case "h6": {
                            return this.transformInline(nodeToTransform, nodeName + ". ");
                        }
                        case "ul": 
                        case "ol": {
                            return this.listNodeTransformer.transformNode(nodeToTransform, wiki);
                        }
                        case "span": {
                            return nodeToTransform.hasAttributes() ? this.blockNodeTransformer.transformNode(nodeToTransform, wiki) : this.transformNodeWithNoWikiMarkUp(nodeToTransform);
                        }
                        case "div": {
                            return this.transformNodeWithNoWikiMarkUp(nodeToTransform, wiki);
                        }
                        case "pre": {
                            return this.transformPreformatted(nodeToTransform);
                        }
                        case "a": {
                            return this.transformLink(nodeToTransform);
                        }
                        case "ac:emoticon": {
                            return this.transformEmoticon(nodeToTransform);
                        }
                    }
                    throw new NonTransformableNodeException(nodeToTransform);
                }
                if (nodeToTransform.getNodeType() == 4) {
                    return nodeToTransform.getTextContent();
                }
                LOGGER.error("DEBUG-INFO: non transformable node found, nodeName:" + nodeToTransform.getNodeName() + ", nodeType: " + nodeToTransform.getNodeType());
                return "";
            }
            catch (NonTransformableNodeException e) {
                return this.generatePlaceholder(nodeToTransform);
            }
        }

        @Nullable
        private String getMacroParameterValue(Node node) {
            if ((node = node.getFirstChild()) == null) {
                return null;
            }
            if (node.getNodeType() == 1) {
                String nodeName;
                switch (nodeName = node.getNodeName()) {
                    case "ri:page": 
                    case "ri:blog-post": {
                        return this.transformBlogPostOrPageNode(node);
                    }
                    case "ri:url": {
                        return node.getAttributes().getNamedItem("ri:value").getNodeValue();
                    }
                    case "ri:space": {
                        return node.getAttributes().getNamedItem("ri:space-key").getNodeValue();
                    }
                    case "ri:user": {
                        Node userKeyNode = node.getAttributes().getNamedItem("ri:userkey");
                        Node userNameNode = node.getAttributes().getNamedItem("ri:username");
                        String userName = null;
                        if (userKeyNode != null) {
                            ConfluenceUser user = SFtoWMTransformer.this.userAccessor.getUserByKey(new UserKey(userKeyNode.getNodeValue()));
                            userName = user != null ? user.getName() : null;
                        } else if (userNameNode != null) {
                            userName = userNameNode.getNodeValue();
                        }
                        return userName;
                    }
                    case "ri:attachment": {
                        return this.transformAttachment(node);
                    }
                    case "ac:link": {
                        return this.transformStorageLink(node, true);
                    }
                }
                throw new NonTransformableNodeException(node);
            }
            if (node.getNodeType() == 3) {
                return node.getTextContent();
            }
            throw new NonTransformableNodeException(node);
        }

        private String transformPreformatted(Node node) {
            String wiki = "{noformat:borderStyle=none}";
            for (Node subnode : XmlUtil.asList(node.getChildNodes())) {
                wiki = wiki + this.transformNode(subnode, wiki);
            }
            wiki = wiki + "{noformat}";
            return wiki;
        }

        private String macroName(Node node) {
            return node.getNodeName().equals("ac:structured-macro") && node.hasAttributes() && node.getAttributes().getNamedItem("ac:name") != null ? node.getAttributes().getNamedItem("ac:name").getNodeValue() : "";
        }

        public String contractNewlines(String str) {
            return str.replaceAll("(" + NEW_LINE + " *){3,}", NEW_LINE + NEW_LINE);
        }

        private String transformInline(Node node, String inlineMarkUp) {
            String wiki = NEW_LINE + inlineMarkUp;
            if (node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3) {
                wiki = wiki + node.getTextContent();
            } else {
                for (Node subnode : XmlUtil.asList(node.getChildNodes())) {
                    wiki = wiki + this.transformNode(subnode, wiki);
                }
            }
            wiki = wiki + NEW_LINE;
            return wiki;
        }

        private String transformVoidElement(Node node, String precedingWiki) {
            if (node.getNodeName().equals("br")) {
                if (!this.hasStructuredParent(node).booleanValue() && this.isBlockElementSupportingNewLines(node.getParentNode()) && !this.isInlineElement(node.getParentNode()) || this.getParentMacroWithName(node, "noformat") != null) {
                    return NEW_LINE;
                }
                return (precedingWiki.endsWith(SFtoWMTransformer.SPACE) ? "" : SFtoWMTransformer.SPACE) + "\\\\ ";
            }
            if (node.getNodeName().equals("hr")) {
                if (!this.hasStructuredParent(node).booleanValue()) {
                    return NEW_LINE + "----" + NEW_LINE;
                }
                throw new NonTransformableNodeException(node);
            }
            throw new NonTransformableNodeException(node);
        }

        private boolean isInlineElement(Node node) {
            switch (node.getNodeName()) {
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    return true;
                }
            }
            return false;
        }

        private boolean isBlockElementSupportingNewLines(Node node) {
            switch (node.getNodeName()) {
                case "b": 
                case "strong": 
                case "em": 
                case "i": 
                case "s": 
                case "del": 
                case "u": 
                case "sup": 
                case "sub": 
                case "cite": 
                case "code": {
                    return false;
                }
            }
            return true;
        }

        private String transformStorageLink(Node node, boolean isMacroParameter) {
            return !isMacroParameter ? "[" + this.transformStorageLinkNode(node) + "]" : this.transformStorageLinkNode(node);
        }

        private String transformStorageLinkNode(Node node) {
            String spaceKey = "";
            String attachment = "";
            String blogPostOrPage = "";
            String anchor = "";
            String linkBody = "";
            String shortcutKey = null;
            String shortcutParameter = null;
            String userName = "";
            NamedNodeMap linkNodeAttrs = node.getAttributes();
            if (linkNodeAttrs != null && linkNodeAttrs.getNamedItem("ac:anchor") != null) {
                anchor = "#" + linkNodeAttrs.getNamedItem("ac:anchor").getNodeValue();
            }
            block19: for (Node subnode : XmlUtil.asList(node.getChildNodes())) {
                NamedNodeMap subnodeAttributes = subnode.getAttributes();
                switch (subnode.getNodeName()) {
                    case "ac:plain-text-link-body": {
                        for (Node subSubNode : XmlUtil.asList(subnode.getChildNodes())) {
                            if (subSubNode.getNodeType() != 4) continue;
                            linkBody = subSubNode.getNodeValue();
                        }
                        continue block19;
                    }
                    case "ri:blog-post": 
                    case "ri:page": {
                        blogPostOrPage = this.transformBlogPostOrPageNode(subnode);
                        break;
                    }
                    case "ri:space": {
                        if (subnodeAttributes == null || subnodeAttributes.getNamedItem("ri:space-key") == null) break;
                        spaceKey = subnodeAttributes.getNamedItem("ri:space-key").getNodeValue() + ":";
                        break;
                    }
                    case "ri:attachment": {
                        attachment = this.transformAttachment(subnode);
                        break;
                    }
                    case "ac:link-body": {
                        linkBody = this.transformNodeWithNoWikiMarkUp(subnode);
                        break;
                    }
                    case "ri:user": {
                        if (subnodeAttributes == null) break;
                        Node userKeyNode = subnodeAttributes.getNamedItem("ri:userkey");
                        Node userNameNode = subnodeAttributes.getNamedItem("ri:username");
                        if (userKeyNode != null) {
                            String userKeyValue = userKeyNode.getNodeValue();
                            ConfluenceUser user = SFtoWMTransformer.this.userAccessor.getUserByKey(new UserKey(userKeyValue));
                            if (user != null) {
                                userName = user.getName();
                                break;
                            }
                            throw new NonTransformableNodeException(node);
                        }
                        if (userNameNode == null) continue block19;
                        userName = userNameNode.getNodeValue();
                        break;
                    }
                    case "ri:shortcut": {
                        if (subnodeAttributes == null) break;
                        shortcutKey = subnodeAttributes.getNamedItem("ri:key").getNodeValue();
                        shortcutParameter = subnodeAttributes.getNamedItem("ri:parameter").getNodeValue();
                    }
                }
            }
            if (!linkBody.isEmpty()) {
                linkBody = linkBody + "|";
            }
            if (!userName.equals("")) {
                return linkBody + "~" + userName;
            }
            if (!attachment.isEmpty()) {
                return linkBody + attachment;
            }
            if (shortcutKey != null && shortcutParameter != null) {
                if (!linkBody.equals(shortcutParameter + "@" + shortcutKey + "|")) {
                    return linkBody + shortcutParameter + "@" + shortcutKey;
                }
                return shortcutParameter + "@" + shortcutKey;
            }
            if (linkBody.isEmpty() && spaceKey.isEmpty() && blogPostOrPage.isEmpty() && anchor.isEmpty()) {
                return "|";
            }
            return linkBody + spaceKey + blogPostOrPage + anchor;
        }

        private String transformBlogPostOrPageNode(Node node) {
            String blogPostingDate = "";
            String pageTitle = "";
            String spaceKey = "";
            NamedNodeMap subnodeAttributes = node.getAttributes();
            if (subnodeAttributes != null) {
                switch (node.getNodeName()) {
                    case "ri:blog-post": {
                        if (subnodeAttributes.getNamedItem("ri:posting-day") != null) {
                            blogPostingDate = "/" + subnodeAttributes.getNamedItem("ri:posting-day").getNodeValue();
                        }
                    }
                    case "ri:page": {
                        if (subnodeAttributes.getNamedItem("ri:content-title") != null) {
                            pageTitle = subnodeAttributes.getNamedItem("ri:content-title").getNodeValue();
                        }
                        if (subnodeAttributes.getNamedItem("ri:space-key") == null) break;
                        spaceKey = subnodeAttributes.getNamedItem("ri:space-key").getNodeValue() + ":";
                        break;
                    }
                    default: {
                        throw new NonTransformableNodeException(node);
                    }
                }
                if (!blogPostingDate.isEmpty()) {
                    if (!pageTitle.isEmpty()) {
                        return spaceKey + blogPostingDate + "/" + pageTitle;
                    }
                    return spaceKey + blogPostingDate;
                }
                return spaceKey + pageTitle;
            }
            throw new NonTransformableNodeException(node);
        }

        private String transformLink(Node node) {
            if (node.getAttributes().getNamedItem("href") != null) {
                String link = node.getAttributes().getNamedItem("href").getNodeValue();
                if (link.substring(0, 7).equals("mailto:")) {
                    if (!link.substring(7).equals(node.getTextContent().trim())) {
                        return "[" + node.getTextContent().trim() + "|" + link + "]";
                    }
                    return "[" + link + "]";
                }
                if (!link.endsWith("/")) {
                    link = link + "/";
                }
                for (Node subNode : XmlUtil.asList(node.getChildNodes())) {
                    if (!subNode.getNodeName().equals("ac:image")) continue;
                    return "[" + this.transformImage(subNode) + "|" + link + "]";
                }
                return "[" + node.getTextContent().trim() + "|" + link + "]";
            }
            throw new NonTransformableNodeException(node);
        }

        private String transformImage(Node node) {
            String attributes = "";
            if (node.hasAttributes()) {
                for (Node attribute : XmlUtil.asList(node.getAttributes())) {
                    attributes = attributes + (StringUtils.isEmpty((CharSequence)attributes) ? "|" : ", ");
                    attributes = attributes + attribute.getNodeName().substring(3) + "=" + attribute.getNodeValue();
                }
            }
            for (Node subNode : XmlUtil.asList(node.getChildNodes())) {
                if (subNode.getNodeName().equals("ri:attachment")) {
                    return "!" + this.transformAttachment(subNode) + attributes + "!";
                }
                if (!subNode.getNodeName().equals("ri:url") || subNode.getAttributes() == null || subNode.getAttributes().getNamedItem("ri:value") == null) continue;
                return "!" + subNode.getAttributes().getNamedItem("ri:value").getNodeValue() + attributes + "!";
            }
            throw new NonTransformableNodeException(node);
        }

        private String transformAttachment(Node node) {
            NamedNodeMap nodeAttributes = node.getAttributes();
            if (nodeAttributes != null) {
                Node pageOrBlogPost = node.getFirstChild();
                String referenceToPageOrBlogPos = "";
                if (pageOrBlogPost != null) {
                    referenceToPageOrBlogPos = this.transformBlogPostOrPageNode(pageOrBlogPost);
                } else if (this.relatedAbstractPage instanceof BlogPost) {
                    BlogPost blogPost = (BlogPost)this.relatedAbstractPage;
                    referenceToPageOrBlogPos = "/" + blogPost.getDatePath() + "/" + blogPost.getTitle();
                }
                String filename = nodeAttributes.getNamedItem("ri:filename").getNodeValue();
                return referenceToPageOrBlogPos + "^" + filename;
            }
            throw new NonTransformableNodeException(node);
        }

        private String transformText(Node textNode) {
            String text = textNode.getTextContent();
            boolean isSpaceSeq = Pattern.matches("^[\\n\\r\\f]+$", text);
            return !isSpaceSeq ? this.substituteNewLinesWithWiki(text) : "";
        }

        private String substituteNewLinesWithWiki(String text) {
            return text.replaceAll("\\r\\n|\\n", " \\ ");
        }

        private String[] findSpaces(Node textNode) {
            String text = textNode.getTextContent();
            return this.findSpaces(text);
        }

        private String[] findSpaces(String text) {
            String[] matches = new String[]{"", "", ""};
            Pattern pattern = Pattern.compile("( *)(.*?)( *)", 32);
            Matcher m = pattern.matcher(text);
            boolean match = m.matches();
            if (match) {
                matches[0] = m.group(1);
                matches[1] = m.group(2);
                matches[2] = m.group(3);
            }
            return matches;
        }

        private String contractSpaces(String str) {
            return str.replaceAll(" {2,}", SFtoWMTransformer.SPACE);
        }

        private String rightTrim(String s) {
            int i;
            for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
            }
            return s.substring(0, i + 1);
        }

        private String leftTrim(String s) {
            int i;
            for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            return s.substring(i);
        }

        private String generatePlaceholder(Node node) {
            Integer n = this.nonTransformableNodeId;
            Integer n2 = this.nonTransformableNodeId = Integer.valueOf(this.nonTransformableNodeId + 1);
            this.nonTransformableElements.put(this.nonTransformableNodeId, node);
            return "{apc-noneditable-element-placeholder:id=" + this.nonTransformableNodeId + "}";
        }

        private String transformTable(Node nodeToTransform) {
            NodeList subnodes = nodeToTransform.getChildNodes();
            for (Node node : XmlUtil.asList(subnodes)) {
                if (!node.getNodeName().equals("tbody")) continue;
                nodeToTransform = node;
                subnodes = nodeToTransform.getChildNodes();
                break;
            }
            String wiki = "";
            if (nodeToTransform.hasChildNodes()) {
                wiki = wiki + NEW_LINE;
                for (Node row : XmlUtil.asList(subnodes)) {
                    if (!row.hasChildNodes()) continue;
                    String markUp = "|";
                    block10: for (Node cell : XmlUtil.asList(row.getChildNodes())) {
                        if (cell.hasAttributes()) {
                            int colspan = 1;
                            int rowspan = 1;
                            if (cell.getAttributes().getNamedItem("colspan") != null) {
                                colspan = Integer.parseInt(cell.getAttributes().getNamedItem("colspan").getNodeValue());
                            }
                            if (cell.getAttributes().getNamedItem("rowspan") != null) {
                                rowspan = Integer.parseInt(cell.getAttributes().getNamedItem("rowspan").getNodeValue());
                            }
                            if (rowspan > 1 || colspan > 1) {
                                throw new NonTransformableNodeException(nodeToTransform);
                            }
                        }
                        NodeList cellContents = cell.getChildNodes();
                        switch (cell.getNodeName()) {
                            case "th": {
                                markUp = " ||";
                                wiki = wiki + markUp;
                                for (Node cellContent : XmlUtil.asList(cellContents)) {
                                    wiki = this.rightTrim(wiki + this.transformNode(cellContent, wiki));
                                }
                                continue block10;
                            }
                            case "td": {
                                markUp = " |";
                                wiki = wiki + markUp;
                                for (Node cellContent : XmlUtil.asList(cellContents)) {
                                    wiki = this.rightTrim(wiki + this.transformNode(cellContent, wiki));
                                }
                                break;
                            }
                        }
                    }
                    if (wiki.endsWith(NEW_LINE)) {
                        wiki = this.rightTrim(wiki) + SFtoWMTransformer.SPACE;
                    }
                    wiki = wiki + SFtoWMTransformer.SPACE + markUp + NEW_LINE;
                }
            }
            wiki = wiki + NEW_LINE;
            return wiki;
        }

        private String transformNodeWithNoWikiMarkUp(Node nodeToTransform) {
            return this.transformNodeWithNoWikiMarkUp(nodeToTransform, "");
        }

        private String transformNodeWithNoWikiMarkUp(Node nodeToTransform, String precedingWiki) {
            String wiki = "";
            for (Node subnode : XmlUtil.asList(nodeToTransform.getChildNodes())) {
                String transformed = this.transformNode(subnode, precedingWiki);
                precedingWiki = precedingWiki + transformed;
                wiki = wiki + transformed;
            }
            return wiki;
        }

        private String transformMacro(Node node) {
            String macroName = node.getAttributes().getNamedItem("ac:name").getNodeValue();
            if (macroName.startsWith("unmigrated-")) {
                for (Node subnode : XmlUtil.asList(node.getChildNodes())) {
                    if (!subnode.getNodeName().equals("ac:plain-text-body")) continue;
                    return subnode.getTextContent();
                }
            }
            if (NON_TRANSFORMABLE_MACROS.contains(macroName)) {
                throw new NonTransformableNodeException(node);
            }
            String wiki = "{" + macroName;
            String parameters = "";
            if (node.hasChildNodes()) {
                boolean isFirstParameter = true;
                for (Node subnode : XmlUtil.asList(node.getChildNodes())) {
                    if (subnode.getNodeName().equals("ac:parameter") && subnode.hasAttributes()) {
                        String parameterValue = this.getMacroParameterValue(subnode);
                        if (parameterValue == null) continue;
                        String parameterName = subnode.getAttributes().getNamedItem("ac:name").getNodeValue();
                        if (parameterName.equals("")) {
                            parameters = parameters.isEmpty() ? ":" + parameterValue + parameters : ":" + parameterValue + "|" + parameters.substring(1);
                            isFirstParameter = false;
                            continue;
                        }
                        if (isFirstParameter) {
                            parameters = parameters + ":" + parameterName + "=" + parameterValue;
                            isFirstParameter = false;
                            continue;
                        }
                        parameters = parameters + "|" + parameterName + "=" + parameterValue;
                        continue;
                    }
                    if (!subnode.getNodeName().equals("ac:rich-text-body") && !subnode.getNodeName().equals("ac:plain-text-body")) continue;
                    wiki = wiki + parameters + "}" + this.transformNodeWithNoWikiMarkUp(subnode) + "{" + macroName + "}";
                    return wiki;
                }
            }
            wiki = wiki + parameters + "}";
            return wiki;
        }

        private String transformEmoticon(Node node) {
            String emoticonWiki = (String)WIKI_EMOTICONS.get(node.getAttributes().getNamedItem("ac:name").getNodeValue());
            if (emoticonWiki != null) {
                return emoticonWiki + SFtoWMTransformer.SPACE;
            }
            throw new NonTransformableNodeException(node);
        }

        private Boolean hasStructuredParent(Node node) {
            Node parentNode = node;
            while (parentNode.getParentNode() != null && !parentNode.getParentNode().equals(node)) {
                String parentNodeName = (parentNode = parentNode.getParentNode()).getNodeName();
                if (!parentNodeName.equals("table") && !parentNodeName.equals("ul") && !parentNodeName.equals("ol")) continue;
                return true;
            }
            return false;
        }

        private Node getParentMacroWithName(Node node, String parentMacroName) {
            Node parentNode = node;
            while (parentNode.getParentNode() != null && !parentNode.getParentNode().equals(node)) {
                if (!this.macroName(parentNode = parentNode.getParentNode()).equals(parentMacroName)) continue;
                return parentNode;
            }
            return null;
        }

        private Boolean hasParentWithSameName(Node node) {
            Node parentNode = node;
            while (parentNode.getParentNode() != null && !parentNode.getParentNode().equals(node)) {
                if (!(parentNode = parentNode.getParentNode()).getNodeName().equals(node.getNodeName())) continue;
                if (node.getAttributes() != null && parentNode.getAttributes() != null && node.getAttributes().getNamedItem("ac:name") != null && parentNode.getAttributes().getNamedItem("ac:name") != null) {
                    if (!node.getAttributes().getNamedItem("ac:name").getNodeValue().equals(parentNode.getAttributes().getNamedItem("ac:name").getNodeValue())) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        private class NonTransformableNodeException
        extends RuntimeException {
            private Node node;

            public NonTransformableNodeException(Node node) {
                super("The" + node.getNodeName() + " node could not be transformed and will be replaced with original XML.");
                this.node = node;
            }

            public Node getNode() {
                return this.node;
            }
        }

        private class ListNodeTransformer {
            private Boolean parentsSupportNewLine;

            private ListNodeTransformer() {
            }

            private String transformNode(Node node, String precedingWiki) throws NonTransformableNodeException {
                String wikiMarkUp;
                if (node.getNodeName().equals("ul")) {
                    wikiMarkUp = "*";
                } else if (node.getNodeName().equals("ol")) {
                    wikiMarkUp = "#";
                } else {
                    throw new NonTransformableNodeException(node);
                }
                return this.transformNode(node, wikiMarkUp, precedingWiki);
            }

            private String transformNode(Node listNode, String listMarkUp, String precedingWiki) {
                String wiki = "";
                this.parentsSupportNewLine = Worker.this.hasStructuredParent(listNode) == false;
                if (!listNode.hasChildNodes()) {
                    return wiki;
                }
                if (listMarkUp.length() == 1 && !precedingWiki.endsWith("|") && !precedingWiki.endsWith(NEW_LINE)) {
                    wiki = wiki + NEW_LINE;
                }
                for (Node nextNode : XmlUtil.asList(listNode.getChildNodes())) {
                    if (nextNode.getNodeName().equals("li")) {
                        Boolean newLinePlaced = false;
                        if (nextNode.hasChildNodes()) {
                            wiki = wiki + listMarkUp + SFtoWMTransformer.SPACE;
                            for (Node subnode : XmlUtil.asList(nextNode.getChildNodes())) {
                                String subnodeNodeName = subnode.getNodeName();
                                if (subnodeNodeName.equals("ul") || subnodeNodeName.equals("ol")) {
                                    if (!newLinePlaced.booleanValue()) {
                                        newLinePlaced = true;
                                        wiki = wiki + NEW_LINE;
                                    } else {
                                        newLinePlaced = false;
                                    }
                                    String tag = subnodeNodeName.equals("ul") ? "*" : "#";
                                    wiki = wiki + this.transformNode(subnode, listMarkUp + tag, wiki);
                                    continue;
                                }
                                wiki = wiki + Worker.this.transformNode(subnode, wiki);
                            }
                        }
                        if (newLinePlaced.booleanValue() || wiki.endsWith(NEW_LINE)) continue;
                        wiki = wiki + NEW_LINE;
                        continue;
                    }
                    wiki = wiki + Worker.this.transformNode(nextNode, wiki);
                }
                if (this.parentsSupportNewLine.booleanValue() && listMarkUp.length() == 1) {
                    wiki = wiki + NEW_LINE + NEW_LINE;
                }
                return wiki;
            }
        }

        private class BlockNodeTransformer {
            private Map<String, String> wikiForNodesInStorageFmt = new HashMap<String, String>();
            private Boolean secondElementAfterSpaces;
            private Boolean secondLastElementAfterSpaces;
            private Boolean lastElement;
            private Boolean firstElement;
            private Boolean parentsSupportNewLine;

            private BlockNodeTransformer() {
                this.wikiForNodesInStorageFmt.put("em", "_");
                this.wikiForNodesInStorageFmt.put("i", "_");
                this.wikiForNodesInStorageFmt.put("s", "-");
                this.wikiForNodesInStorageFmt.put("del", "-");
                this.wikiForNodesInStorageFmt.put("u", "+");
                this.wikiForNodesInStorageFmt.put("sup", "^");
                this.wikiForNodesInStorageFmt.put("sub", "~");
                this.wikiForNodesInStorageFmt.put("b", "*");
                this.wikiForNodesInStorageFmt.put("strong", "*");
                this.wikiForNodesInStorageFmt.put("cite", "??");
                this.resetState();
            }

            private void resetState() {
                this.firstElement = false;
                this.lastElement = false;
                this.secondLastElementAfterSpaces = false;
                this.secondElementAfterSpaces = false;
            }

            public String transformNode(Node node, String precedingWiki) throws NonTransformableNodeException {
                this.parentsSupportNewLine = Worker.this.hasStructuredParent(node) == false;
                this.resetState();
                for (Map.Entry<String, String> entry : this.wikiForNodesInStorageFmt.entrySet()) {
                    if (!node.getNodeName().equals(entry.getKey())) continue;
                    String wikiMarkUpStart = entry.getValue();
                    return this.transformNode(node, wikiMarkUpStart, wikiMarkUpStart, precedingWiki);
                }
                if (node.getNodeName().equals("span")) {
                    if (node.hasAttributes() && node.getAttributes().getNamedItem("style") != null) {
                        String styleAttribute = node.getAttributes().getNamedItem("style").getNodeValue();
                        if (styleAttribute.startsWith("color")) {
                            String wikiMarkUpStart = "{" + styleAttribute.substring(0, styleAttribute.length() - 1) + "}";
                            String wikiMarkUpEnd = "{color}";
                            return this.transformNode(node, wikiMarkUpStart, wikiMarkUpEnd, precedingWiki);
                        }
                        if (styleAttribute.startsWith("text-decoration: line-through")) {
                            String wikiMarkUpStart = "-";
                            String wikiMarkUpEnd = "-";
                            return this.transformNode(node, wikiMarkUpStart, wikiMarkUpEnd, precedingWiki);
                        }
                        if (styleAttribute.startsWith("text-decoration: underline")) {
                            String wikiMarkUpStart = "+";
                            String wikiMarkUpEnd = "+";
                            return this.transformNode(node, wikiMarkUpStart, wikiMarkUpEnd, precedingWiki);
                        }
                        return Worker.this.transformNodeWithNoWikiMarkUp(node);
                    }
                } else {
                    if (node.getNodeName().equals("code")) {
                        String wikiMarkUpStart = " {{";
                        String wikiMarkUpEnd = "}} ";
                        return this.transformNode(node, wikiMarkUpStart, wikiMarkUpEnd, precedingWiki);
                    }
                    if (node.getNodeName().equals("p")) {
                        if (this.parentsSupportNewLine.booleanValue()) {
                            String wikiMarkUpStart = NEW_LINE + NEW_LINE;
                            String wikiMarkUpEnd = NEW_LINE + NEW_LINE;
                            return this.transformNode(node, wikiMarkUpStart, wikiMarkUpEnd, precedingWiki);
                        }
                        String wikiMarkUpStart = precedingWiki.endsWith("|") || precedingWiki.endsWith(NEW_LINE) ? "" : NEW_LINE;
                        String wikiMarkUpEnd = NEW_LINE;
                        return this.transformNode(node, wikiMarkUpStart, wikiMarkUpEnd, precedingWiki);
                    }
                    if (node.getNodeName().equals("blockquote")) {
                        return this.transformNode(node, "{quote}", "{quote}", precedingWiki);
                    }
                }
                throw new NonTransformableNodeException(node);
            }

            private String transformNode(Node nodeToTransform, String blockMarkUpStart, String blockMarkUpEnd, String precedingWiki) {
                String blockMarkUpEmbracedEnd;
                String blockMarkUpEmbracedStart;
                String wikiStart = "";
                if (blockMarkUpStart.startsWith(SFtoWMTransformer.SPACE) || blockMarkUpStart.startsWith("{") || blockMarkUpStart.isEmpty() || blockMarkUpStart.startsWith(NEW_LINE)) {
                    blockMarkUpEmbracedStart = blockMarkUpStart;
                    blockMarkUpEmbracedEnd = blockMarkUpEnd;
                } else {
                    blockMarkUpEmbracedStart = "{" + blockMarkUpStart + "}";
                    blockMarkUpEmbracedEnd = "{" + blockMarkUpEnd + "}";
                }
                Boolean lastElement = this.lastElement;
                Boolean firstElement = this.firstElement;
                Boolean secondElementAfterSpaces = this.secondElementAfterSpaces;
                Boolean secondLastElementAfterSpaces = this.secondLastElementAfterSpaces;
                String[] textAndSpaces = Worker.this.findSpaces(nodeToTransform);
                wikiStart = !precedingWiki.endsWith(SFtoWMTransformer.SPACE) ? (!(textAndSpaces[0].isEmpty() || firstElement.booleanValue() || secondElementAfterSpaces.booleanValue()) ? wikiStart + textAndSpaces[0] + blockMarkUpStart : wikiStart + blockMarkUpEmbracedStart) : wikiStart + blockMarkUpStart;
                String wikiEnd = !textAndSpaces[2].isEmpty() && lastElement == false && secondLastElementAfterSpaces == false ? blockMarkUpEnd + textAndSpaces[2] : blockMarkUpEmbracedEnd;
                Integer numberOfChildNodes = nodeToTransform.getChildNodes().getLength();
                for (int j = 0; j < numberOfChildNodes; ++j) {
                    Node subnode2 = nodeToTransform.getChildNodes().item(j);
                    switch (j) {
                        case 0: {
                            this.firstElement = true;
                            if (subnode2.getNodeType() != 3) break;
                            subnode2.setTextContent(Worker.this.leftTrim(subnode2.getTextContent()));
                            break;
                        }
                        default: {
                            this.firstElement = false;
                        }
                    }
                    this.secondElementAfterSpaces = j == 1;
                    if (j == numberOfChildNodes - 1) {
                        this.lastElement = true;
                        if (subnode2.getNodeType() == 3) {
                            subnode2.setTextContent(Worker.this.rightTrim(subnode2.getTextContent()));
                        }
                    } else {
                        this.lastElement = false;
                    }
                    this.secondLastElementAfterSpaces = j == numberOfChildNodes - 2;
                    wikiStart = wikiStart + Worker.this.transformNode(subnode2, precedingWiki);
                }
                wikiStart = wikiStart + wikiEnd;
                return wikiStart;
            }
        }
    }

    public static class TransformResult {
        private ContentRepresentation contentRepresentation;
        private Map<Integer, Node> nonTransformableElements;

        @Nullable
        public ContentRepresentation getContentRepresentation() {
            return this.contentRepresentation;
        }

        public void setContentRepresentation(ContentRepresentation wikiMarkup) {
            this.contentRepresentation = wikiMarkup;
        }

        @Nullable
        public Map<Integer, Node> getNonTransformableElements() {
            return this.nonTransformableElements;
        }

        public void setNonTransformableElements(@Nullable Map<Integer, Node> nonTransformableElements) {
            this.nonTransformableElements = nonTransformableElements;
        }
    }
}

