/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.listener;

import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.LoginRequestThreadLocal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginEventListener.class);
    private final APCUtils apcUtils;
    private final UserAccessor userAccessor;

    public LoginEventListener(APCUtils apcUtils, UserAccessor userAccessor) {
        this.apcUtils = apcUtils;
        this.userAccessor = userAccessor;
    }

    @EventListener
    public void handleLoginEvent(LoginEvent event) {
        try {
            HttpSession session;
            HttpServletRequest request;
            ConfluenceUser user = this.userAccessor.getUserByName(event.getUsername());
            if (user != null && (request = LoginRequestThreadLocal.getRequest()) != null && (session = request.getSession(false)) != null) {
                String apcLoginMode = request.getParameter("apc_login_mode");
                this.apcUtils.setAPCMode(user, session, "on".equals(apcLoginMode));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Login event failed", (Throwable)e);
        }
    }
}

