/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.filter;

import com.atlassian.confluence.plugin.webresource.ConfluenceWebResourceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.filters.AbstractHttpFilter;
import de.communardo.confluence.plugins.apc.license.APCLicenseService;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APCRedirectAndMetaTagFilter
extends AbstractHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(APCRedirectAndMetaTagFilter.class);
    private static final Pattern SERVLET_REQUEST_WHITELIST_PATTERN = Pattern.compile("/display|.*\\.action");
    private APCUtils apcUtils;
    private ConfluenceWebResourceManager confluenceWebResourceManager;
    private APCLicenseService apcLicenseService;

    public APCRedirectAndMetaTagFilter(APCUtils apcUtils, ConfluenceWebResourceManager confluenceWebResourceManager, APCLicenseService apcLicenseService) {
        this.apcUtils = apcUtils;
        this.confluenceWebResourceManager = confluenceWebResourceManager;
        this.apcLicenseService = apcLicenseService;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Matcher m;
        if (this.apcLicenseService.isValidLicense() && (m = SERVLET_REQUEST_WHITELIST_PATTERN.matcher(request.getServletPath())).find()) {
            String relativeUrl = this.apcUtils.getAPCRelativeUrl(request);
            boolean existsAPCModeForPage = StringUtils.isNotBlank((String)relativeUrl);
            boolean isAPCModeEnabled = this.apcUtils.isAPCMode(AuthenticatedUserThreadLocal.get(), request.getSession());
            if (isAPCModeEnabled && existsAPCModeForPage) {
                LOG.debug("Redirect to apc relative url " + relativeUrl);
                response.sendRedirect(relativeUrl);
                return;
            }
            this.confluenceWebResourceManager.putMetadata("apc-exists-apc-mode-for-page", Boolean.toString(existsAPCModeForPage));
            this.confluenceWebResourceManager.putMetadata("apc-is-apc-mode-enabled", Boolean.toString(isAPCModeEnabled));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

