/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.compatibility.search;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;

public class ContentSearchBuilder {
    Collection<SearchQuery> mustQueries;
    SearchSort sort;
    int startOffset = 0;
    int limit = 50;
    boolean useSiteSearchPermissionFilter = true;
    boolean excludeArchivedSpaces = false;
    boolean excludeInactiveUsers = false;
    private final Function<ContentSearchBuilder, ContentSearch> contentSearchCreatorPolicy;

    ContentSearchBuilder(Function<ContentSearchBuilder, ContentSearch> contentSearchCreatorPolicy) {
        this.contentSearchCreatorPolicy = contentSearchCreatorPolicy;
    }

    public ContentSearch createSiteSearch() {
        if (this.sort == null || this.mustQueries == null || this.mustQueries.isEmpty()) {
            throw new IllegalStateException(MessageFormat.format("Both must queries and search sort have to be provided! There were {0} queries and {1} search sort provided.", this.mustQueries == null || this.mustQueries.isEmpty() ? 0 : this.mustQueries.size(), this.sort == null ? "no" : "a"));
        }
        return this.contentSearchCreatorPolicy.apply(this);
    }

    public ContentSearchBuilder addMustQuery(SearchQuery mustQuery) {
        if (this.mustQueries == null) {
            this.mustQueries = new ArrayList<SearchQuery>();
        }
        this.mustQueries.add(mustQuery);
        return this;
    }

    public ContentSearchBuilder setSort(SearchSort sort) {
        this.sort = sort;
        return this;
    }

    public ContentSearchBuilder setStartOffset(int startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    public ContentSearchBuilder setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public ContentSearchBuilder setUseSiteSearchPermissionFilter(boolean useSiteSearchPermissionFilter) {
        this.useSiteSearchPermissionFilter = useSiteSearchPermissionFilter;
        return this;
    }

    public ContentSearchBuilder setExcludeArchivedSpaces(boolean excludeArchivedSpaces) {
        this.excludeArchivedSpaces = excludeArchivedSpaces;
        return this;
    }

    public ContentSearchBuilder setExcludeInactiveUsers(boolean excludeInactiveUsers) {
        this.excludeInactiveUsers = excludeInactiveUsers;
        return this;
    }

    public ContentSearchBuilder addMustQueries(Collection<SearchQuery> mustQueries) {
        mustQueries.forEach(this::addMustQuery);
        return this;
    }
}

