/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.user.AuthenticatorOverwrite;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserForm;
import com.atlassian.confluence.user.UserFormValidator;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.user.actions.UserDetailsMap;
import com.atlassian.confluence.velocity.htmlsafe.HtmlFragment;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.xwork.ParameterSafe;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APCEditMyProfileAction
extends AbstractUserProfileAction
implements CaptchaAware,
FormAware {
    private static final Logger LOG = LoggerFactory.getLogger(APCEditMyProfileAction.class);
    private static final String PARAM_EMAIL = "email";
    private static final String PARAM_FULL_NAME = "fullName";
    private CaptchaManager captchaManager;
    private UserFormValidator validator;
    private UserDetailsMap userDetailsMap;
    private String fullName;
    private String email;
    private String password;
    private StrutsWrapper strutsWrapper;

    public void validate() {
        this.getUserDetailsMap().setParameters(this.strutsWrapper.getParameterMap());
        this.getUserDetailsFromRequest();
        UserForm form = new UserForm(this.getUsername(), this.fullName, this.email);
        this.validator.validateEditUser(form, this.messageHolder);
        String website = this.getUserProperty("website");
        if (!StringUtils.isBlank((String)website) && !this.verifyUrl(website)) {
            if (website.contains("http://") || !this.verifyUrl("http://" + website)) {
                this.addFieldError("userparam-website", this.getText("user.website.invalid"));
            } else {
                this.getUserDetailsMap().setProperty("website", "http://" + website);
            }
        }
    }

    private void getUserDetailsFromRequest() {
        this.fullName = this.strutsWrapper.getValueForRequestParameter(PARAM_FULL_NAME);
        this.email = this.strutsWrapper.getValueForRequestParameter(PARAM_EMAIL);
    }

    public String doInput() {
        if (this.getUser() == null) {
            return "error";
        }
        this.fullName = this.getUser().getFullName();
        this.email = this.getUser().getEmail();
        return "input";
    }

    public String doEdit() {
        if (!this.getFieldErrors().isEmpty()) {
            return "input";
        }
        if (this.isConfirmPassOnEmailChange() && !StringUtils.equalsIgnoreCase((String)this.getUser().getEmail(), (String)this.email) && !this.userAccessor.authenticate(this.getUsername(), this.password)) {
            this.addActionError(this.getText("reenter.password.wrong"));
            return "input";
        }
        boolean shouldUpdatePersonalInfo = this.shouldUpdatePersonalInfo((User)this.getUser(), this.fullName, this.getPersonalInformation());
        try {
            if (!this.settingsManager.getGlobalSettings().isExternalUserManagement() && !this.userAccessor.isReadOnly((User)this.getUser())) {
                this.updateUser();
            }
        }
        catch (CrowdRuntimeException e) {
            this.addActionError(this.getText("edit.my.profile.failed"));
            LOG.warn("Failed to update user profile.", (Throwable)e);
            return "error";
        }
        if (shouldUpdatePersonalInfo) {
            this.personalInformationManager.savePersonalInformation((User)this.getUser(), this.getPersonalInformation(), this.fullName);
        }
        this.getUserDetailsMap().copyPropertiesToManager();
        return this.getFieldErrors().isEmpty() ? "success" : "input";
    }

    public boolean isConfirmPassOnEmailChange() {
        return !AuthenticatorOverwrite.isPasswordConfirmationDisabled();
    }

    private boolean shouldUpdatePersonalInfo(User user, String fullName, String newInfo) {
        PersonalInformation oldInfo = this.getPersonalInformationEntity();
        return oldInfo == null || !newInfo.equals(oldInfo.getBodyContent().getBody()) || this.hasFullNameChanged(user, fullName);
    }

    private boolean hasFullNameChanged(User user, String fullName) {
        return fullName != null && !fullName.trim().equals(user.getFullName());
    }

    private boolean verifyUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void updateUser() {
        DefaultUser userTemplate = new DefaultUser((User)this.getUser());
        userTemplate.setFullName(this.fullName);
        userTemplate.setEmail(this.email);
        this.userAccessor.saveUser((User)userTemplate);
    }

    private UserDetailsMap getUserDetailsMap() {
        if (this.userDetailsMap == null) {
            this.userDetailsMap = new UserDetailsMap((User)this.getUser(), this.userDetailsManager);
        }
        return this.userDetailsMap;
    }

    public String getUserProperty(String key) {
        String value = this.getUserDetailsMap().getProperty(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public boolean isEditMode() {
        return true;
    }

    public HtmlFragment getFullName() {
        return new HtmlFragment((Object)this.fullName);
    }

    @ParameterSafe
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public HtmlFragment getEmail() {
        return new HtmlFragment((Object)this.email);
    }

    @ParameterSafe
    public void setEmail(String email) {
        this.email = email;
    }

    public String getStoredEmail() {
        return this.getUser().getEmail();
    }

    @ParameterSafe
    public void setPasswordconfirmation(String password) {
        this.password = password;
    }

    public List<String> getUserDetailsKeys(String groupKey) {
        return this.userDetailsManager.getProfileKeys(groupKey);
    }

    public List<String> getUserDetailsGroups() {
        return this.userDetailsManager.getProfileGroups();
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    public void setUserFormValidator(UserFormValidator validator) {
        this.validator = validator;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

