/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.service.comment.CreateCommentCommand;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.actions.ServiceBackedActionHelper;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.actions.AddCommentAction;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class APCAddCommentAction
extends AddCommentAction {
    private static final long serialVersionUID = 269911696211240054L;
    private APCUtils apcUtils;
    private CreateCommentCommand createCommentCommand;
    private long attachmentId;
    private boolean watchPageAfterComment;
    private CommentService commentService;
    private NotificationManager notificationManager;
    private StrutsWrapper strutsWrapper;

    @ParameterSafe
    public void setWikiMarkupContent(String wikiMarkupContent) {
        long id = Long.parseLong(this.strutsWrapper.getValueForRequestParameter("pageId"));
        ContentRepresentation contentRepresentation = ContentRepresentation.createWithoutLayout(wikiMarkupContent);
        super.setWysiwygContent(this.apcUtils.convertWikiMarkupToWysiwyg(contentRepresentation, id));
    }

    public String execute() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.back)) {
            return "input";
        }
        if (StringUtils.isNotEmpty((CharSequence)this.preview)) {
            this.updateXHtmlContent();
            this.setInPreview(true);
            return "preview";
        }
        this.updateXHtmlContent();
        this.getAddCommentCommand().execute();
        if (this.watchPageAfterComment) {
            this.notificationManager.addContentNotification((User)this.getAuthenticatedUser(), (ContentEntityObject)this.getPage());
        }
        return "success";
    }

    public void validate() {
        if (this.attachmentId == 0L) {
            super.validate();
        } else if (!this.getAddCommentCommand().isValid()) {
            new ServiceBackedActionHelper((ServiceCommand)this.getAddCommentCommand()).addValidationErrors((ConfluenceActionSupport)this);
        }
    }

    private CreateCommentCommand getAddCommentCommand() {
        if (this.createCommentCommand == null) {
            this.createCommentCommand = this.attachmentId == 0L ? this.commentService.newCreateCommentFromEditorCommand(this.getPageId(), super.getParentId(), this.wysiwygContent, UUID.randomUUID()) : this.commentService.newCreateCommentFromEditorCommand(this.attachmentId, super.getParentId(), this.wysiwygContent, UUID.randomUUID());
        }
        return this.createCommentCommand;
    }

    public long getAttachmentId() {
        return this.attachmentId;
    }

    @ParameterSafe
    public void setAttachmentId(long attachmentId) {
        this.attachmentId = attachmentId;
    }

    @ParameterSafe
    public void setWatchPageAfterComment(boolean watchPageAfterComment) {
        this.watchPageAfterComment = watchPageAfterComment;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setNewCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setApcUtils(APCUtils apcUtils) {
        this.apcUtils = apcUtils;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

