AJS.toInit(function($) {
    // creates a base64 representation of file and uploads it to confluence
    function uploadProfilePicture(file) {
        var reader = new FileReader();
        reader.readAsDataURL(file);
        reader.onload = function () {
            var userKey = AJS.Meta.get('remote-user-key');
            $.ajax({
                type:'POST',
                dataType:"json",
                contentType:"application/json",
                data: JSON.stringify({
                    avatarDataURI: reader.result
                }),
                url: AJS.contextPath() + '/rest/user-profile/1.0/' + userKey + '/avatar/upload',
                success: function(data) {
                    window.location = AJS.contextPath() + "/apc/users/editmyprofilepicture.action";
                },
                error:function (xhr) {
                    createErrorMessage(AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.profile.options.avatar.error.general'));
                }
            });
        };
        reader.onerror = function (error) {
            console.log('Error: ', error);
        };
    }

    function createErrorMessage(errorMessage) {
        if(apcProfilePictureInput.length) {
            var $apcProfilePictureInputParent = apcProfilePictureInput.parent();
            var $errorDiv = $apcProfilePictureInputParent.find('.error-area');
            if (!$errorDiv.length) {
                $errorDiv = $('<div role="alert" class="error-area">');
                $apcProfilePictureInputParent.append($errorDiv);
            }
            $errorDiv.text(errorMessage);
            apcProfilePictureInput.attr("aria-invalid", "true");
        }
    }

    var apcProfilePictureForm = $("#apcUploadProfilePictureForm"),
        apcProfilePictureInput = $("#apcProfilePictureInput");
    if(apcProfilePictureForm.length && apcProfilePictureInput.length){
        apcProfilePictureForm.submit(function (e) {
            var validateImage, file;
            e.preventDefault();
            if(AJS.Meta.get('access-mode') !== 'READ_ONLY') {
                file = apcProfilePictureInput[0].files[0];
                if(file) {
                    // the maximal file size is defined in the confluence-user-profile plugin in the file
                    // image-upload-and-crop.js (hardcoded) - BFC-804
                    if (file.size > 10 * 1024 * 1024) { // 10 MB
                        createErrorMessage(AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.profile.options.avatar.error.filesize'));
                        return;
                    }

                    validateImage = new Image();
                    validateImage.onload = function() {
                        // the maximal dimensions is also hardcoded in image-upload-and-crop.js - BFC-804
                        if (this.width > 4000 || this.height > 4000) {
                            createErrorMessage(AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.profile.options.avatar.error.wrongDimension'));
                            return;
                        }
                        uploadProfilePicture(file);
                    };
                    validateImage.onerror = function () {
                        createErrorMessage(AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.profile.options.avatar.providePicture'));
                    };
                    validateImage.src = window.URL.createObjectURL(file);
                } else {
                    createErrorMessage(AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.profile.options.avatar.providePicture'));
                }
            } else {
                createErrorMessage(AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.profile.options.avatar.error.readonlymode'));
            }
        })
    }
});