// BFC-551 file and image upload dialog
AJS.bind("show.dialog", function (e, data) {
    AJS.$(document).ajaxComplete(function(event, xhr, settings) {
        var imgBp, imgSelectTick, buildImg, addButtonImages, addButtonImage, imgZoom, imgSelectWhiteTick, targetUrl;
        targetUrl = contextPath + "/rest/prototype/1/content/" + AJS.Meta.get("page-id") + "/attachments.json";

        if (settings.url.indexOf(targetUrl) !== -1) {
            imgSelectTick = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAAAmJLR0QA/4ePzL8AAAAJcEhZcwAACxMAAAsTAQCanBgAAAAHdElNRQfhAxAPMym78PWpAAAAk0lEQVQoz8WRoQ5BYQBGz293mqKazUNo6n0FSRQU4W6q5AkEm8DoZvMCVIkxgmaCB/ACHOUG5sr3q+fsC98H+WXjUYAoG29dUAWgkIUPLimR7AHCL744pUiXSshsuDonopPiVDAeaQxwd8KLNrXv5rGJA42fu749z36y1Bx6o4w8aFEPGQLMPAFNGuHvNCvX5vLJG7shL7+LRz+EAAAAAElFTkSuQmCC';
            imgZoom = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAAeElEQVQoz62Ovw1AYBTEz0pKWqUZPhNI7p4V6CzBPGIBo0g8xReJwuvctb/7A/wuHfTH30CniT2XEAAASzq1hYAGXlqtiiYaumYvrA0bWAMAS+2v5+pyOso4R0ADPae/gN4SL81xw6JTqxcx4NqsspZlCGS/nv+mG6d9RJUXBH/5AAAAAElFTkSuQmCC';
            imgSelectWhiteTick = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAAgUlEQVR4AcXKrw5BcRzG4e803QWcRDRN0CRJMkU3V8BluBFXoEiSizDJFIKZMR7bUfw5v2jeT3nDE3+csZ4QobghVmnQd7NVTYGOi726KAYtJ0dN8QoyC1n+Gg7O2uIdzLGWqdm56opPULHMycbdQHyDUDYDI1EMQsnURCTBs1+ABxXN3umBGxghAAAAAElFTkSuQmCC';
            imgBp = $("<img>");

            buildImg = function (image) {
                var img = imgBp.clone();
                img.attr("src", image);
                img.addClass("abs-icon");
                return img;
            };

            addButtonImage = function (image, parent, cssClass) {
                var img, parentElement;
                img = buildImg(image);
                img.addClass(cssClass);
                parentElement = AJS.$(parent);
                parentElement.each(function (index) {
                    var element;
                    element = AJS.$(this);
                    if (element.find("img").length === 0) {
                        element.append(img.clone());
                    }
                });
            };

            addButtonImages = function () {
                var img;

                // add buttons
                addButtonImage(imgZoom, "#insert-image-dialog .abs-icon.zoom", "zoom");
                addButtonImage(imgSelectTick, "#insert-image-dialog .abs-icon.select", "select");

                // add events
                AJS.$("#insert-image-dialog .attached-file").click(function () {
                    if (!AJS.$(this).hasClass("selected")) {
                        AJS.$(this).find("i img").attr("src", imgSelectWhiteTick);
                    } else {
                        AJS.$(this).find("i img").attr("src", imgSelectTick);
                    }
                });

                AJS.$("#insert-image-dialog .attached-file").on("mouseover", function () {
                    if (!AJS.$(this).hasClass("selected")) {
                        AJS.$(this).find("i img").attr("src", imgSelectTick);
                    } else {
                        AJS.$(this).find("i img").attr("src", imgSelectWhiteTick);
                    }
                });

                AJS.$("#insert-image-dialog .attached-file .abs-icon.zoom").click(function () {
                    var selectImages;
                    selectImages = AJS.$("#insert-image-dialog .attached-file .abs-icon.select");
                    selectImages.each(function (index) {
                        var zoomElement = AJS.$(this);
                        setTimeout(function () {
                            if (!zoomElement.closest("li").hasClass("selected")) {
                                zoomElement.find("img").attr("src", imgSelectTick);
                            } else {
                                zoomElement.find("img").attr("src", imgSelectWhiteTick);
                            }
                        }, 500);
                    });
                });
            };

            if (data.dialog.id === "insert-image-dialog") {
                // initial addition of buttons
                addButtonImages();

                AJS.$("#insert-image-dialog .page-menu-item.selected button").on("click", function () {
                    AJS.$("#attached-files .abs-icon.select img").attr("src", imgSelectTick);
                });

                AJS.$("#insert-image-dialog #search-image-form").submit(function () {
                    var interval = setInterval(function () {
                        var loadingMessage = AJS.$("#insert-image-dialog #searched-images .loading-message");
                        if (loadingMessage.hasClass("hidden")) {
                            addButtonImages();
                            clearInterval(interval);
                        }
                    }, 50);
                });
            }

            AJS.$(document).ajaxComplete(function(event, xhr, settings) {
                targetUrl = contextPath + "/rest/prototype/1/attachment/";
                if(settings.url.indexOf(targetUrl) !== -1) {
                    addButtonImages();
                    AJS.$("#attached-files .attached-file").trigger("mouseover");
                }
            });
        }
    });
});