AJS.$(document).ready(function($) {

    var interval = 5000; // in ms

    var checkForHCM = function() {
        var hcmElement = $('<div id="apc-test-high-contrast" />').css({
            width: '0px',
            height: '0px',
            background: 'url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)' // 1px transparent
        });
        hcmElement.appendTo(document.body);

        var isHCM = hcmElement.css('background-image') == 'none';
        var wasHCM = apc.hcm.isHCM;

        if (isHCM != wasHCM) {
            $(document).trigger('apc-hcm-changed', isHCM);
        }

        hcmElement.remove();

        apc.hcm.isHCM = isHCM;

        return isHCM;
    };

    var timer = setInterval(checkForHCM, interval);

    apc.hcm = {
        interval: interval,
        checkForHCM: checkForHCM,
        timer: timer,
        isHCM: false
    };

    setTimeout(checkForHCM, 1000); // run once on init after 1s

    $(document).on('apc-hcm-changed', function(event, isHCM) {
        console && console.log && console.log('APC: HCM ' + (isHCM ? 'enabled' : 'disabled'));
    });
});