/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.listener;

import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.LoginRequestThreadLocal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LoginEventListener {
    private APCUtils apcUtils;
    private UserAccessor userAccessor;

    public LoginEventListener(APCUtils apcUtils, UserAccessor userAccessor) {
        this.apcUtils = apcUtils;
        this.userAccessor = userAccessor;
    }

    @EventListener
    public void handleLoginEvent(LoginEvent event) {
        HttpSession session;
        HttpServletRequest request;
        ConfluenceUser user = this.userAccessor.getUserByName(event.getUsername());
        if (user != null && (request = LoginRequestThreadLocal.getRequest()) != null && (session = request.getSession()) != null) {
            String apcLoginMode = request.getParameter("apc_login_mode");
            this.apcUtils.setAPCMode(user, session, apcLoginMode != null && apcLoginMode.equals("on"));
        }
    }
}

