/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.confluence.pages.actions.EditBlogPostAction;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APCEditBlogPostAction
extends EditBlogPostAction {
    private static final Logger LOG = LoggerFactory.getLogger(APCEditBlogPostAction.class);
    private static final long serialVersionUID = 269911696211240054L;
    private APCUtils apcUtils;
    private ContentRepresentation contentRepresentation;
    private String unexpectedError;
    private StrutsWrapper strutsWrapper;

    public void validate() {
        long id = Long.parseLong(this.strutsWrapper.getValueForRequestParameter("pageId"));
        this.contentRepresentation = this.apcUtils.getContentRepresentationFromRequestParameters(this.strutsWrapper.getParameterMap());
        if (this.contentRepresentation != null) {
            super.setWysiwygContent(this.apcUtils.convertWikiMarkupToWysiwyg(this.contentRepresentation, id));
        }
        super.validate();
    }

    public String doEdit() {
        if (this.contentRepresentation == null) {
            this.unexpectedError = this.getText("de.communardo.confluence.plugins.apc.messages.edit.save.unexpected-error");
            return "error";
        }
        try {
            return super.doEdit();
        }
        catch (Exception e) {
            LOG.error("This should not happen: " + e.getMessage(), (Throwable)e);
            return "Something went wrong - Please contact your administrator and check the logs.";
        }
    }

    public String getUnexpectedError() {
        return this.unexpectedError;
    }

    public void setApcUtils(APCUtils apcUtils) {
        this.apcUtils = apcUtils;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

