/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.license;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APCLicenseService {
    private static final Logger LOG = LoggerFactory.getLogger(APCLicenseService.class);
    private PluginLicenseManager pluginLicenseManager;

    public APCLicenseService(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidLicense() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (!pluginLicense.getError().isDefined()) return true;
            LOG.debug("License found but invalid.");
            return false;
        } else {
            LOG.debug("No installed license found.");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLicenseError() {
        String returnMessage = "";
        if (!this.pluginLicenseManager.getLicense().isDefined()) return "No installed license found.";
        PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
        Option error = pluginLicense.getError();
        if (!error.isDefined()) return "";
        Iterator iterator = error.iterator();
        block7: while (iterator.hasNext()) {
            LicenseError licenseError = (LicenseError)iterator.next();
            switch (licenseError) {
                case USER_MISMATCH: {
                    returnMessage = "Invalid license: The current installed license supports fewer users than the application.";
                    continue block7;
                }
                case EDITION_MISMATCH: {
                    returnMessage = "Invalid license: The current installed license is of a lesser edition than the application license.";
                    continue block7;
                }
                case EXPIRED: {
                    returnMessage = "Invalid license: The current installed license is time-limited and its expiration date has passed.";
                    continue block7;
                }
                case TYPE_MISMATCH: {
                    returnMessage = "Invalid license: The type of the current installed plugin license is incompatible with the license type of the application.";
                    continue block7;
                }
                case VERSION_MISMATCH: {
                    returnMessage = "Invalid license: The current installed license is not valid for the current version of the plugin.";
                    continue block7;
                }
            }
            returnMessage = "Invalid license: License found but invalid.";
        }
        return returnMessage;
    }
}

