/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.util;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.confluence.servlet.simpledisplay.SimpleDisplayServlet;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.confluence.xml.XhtmlEntityResolver;
import com.atlassian.renderer.RenderContext;
import com.opensymphony.module.propertyset.PropertySet;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import de.communardo.confluence.plugins.apc.util.LayoutCell;
import de.communardo.confluence.plugins.apc.util.PlaceholderUtils;
import de.communardo.confluence.plugins.apc.util.SwitchScreenReaderModeUrlMapping;
import de.communardo.confluence.plugins.apc.util.XmlUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class APCUtils {
    private static final XhtmlEntityResolver XHTML_ENTITY_RESOLVER = new XhtmlEntityResolver();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    public static final String PLACEHOLDER_MACRO_NAME = "apc-noneditable-element-placeholder";
    public static final int CF_5_7_BUILDNUMBER = 5780;
    public static final int CF_5_8_BUILDNUMBER = 5980;
    private static final Logger LOGGER = LoggerFactory.getLogger(APCUtils.class);
    private static final String SERVLET_PATH_CONVERTIBLE_URL = "/display";
    private static final SwitchScreenReaderModeUrlMapping APC_ACTION_MAPPINGS = new SwitchScreenReaderModeUrlMapping();
    private BootstrapManager bootstrapManager;
    private PageManager pageManager;
    private PathConverterManager pathConverterManager;
    private SpaceManager spaceManager;
    private AttachmentManager attachmentManager;
    private UserAccessor userAccessor;
    private XhtmlContent xhtmlContent;
    private FormatConverter formatConverter;
    private PlaceholderUtils placeholderUtils;

    public APCUtils(BootstrapManager bootstrapManager, PageManager pageManager, PathConverterManager pathConverterManager, SpaceManager spaceManager, UserAccessor userAccessor, XhtmlContent xhtmlContent, FormatConverter formatConverter, PlaceholderUtils placeholderUtils, AttachmentManager attachmentManager) {
        this.bootstrapManager = bootstrapManager;
        this.pageManager = pageManager;
        this.pathConverterManager = pathConverterManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.xhtmlContent = xhtmlContent;
        this.formatConverter = formatConverter;
        this.placeholderUtils = placeholderUtils;
        this.attachmentManager = attachmentManager;
    }

    public String getContextPath() {
        return this.bootstrapManager.getWebAppContextPath();
    }

    public boolean isAPCMode(@Nullable ConfluenceUser user, @Nullable HttpSession session) {
        boolean isAPCMode = false;
        if (session != null) {
            Object isAPCModeObject = session.getAttribute("screenReaderMode");
            if (isAPCModeObject == null) {
                PropertySet propertySet = this.userAccessor.getPropertySet(user);
                if (propertySet != null) {
                    isAPCMode = propertySet.getBoolean("de.communardo.confluence.plugins.apc.mode.active");
                    session.setAttribute("screenReaderMode", (Object)isAPCMode);
                }
            } else {
                isAPCMode = Boolean.parseBoolean(isAPCModeObject.toString());
            }
        }
        return isAPCMode;
    }

    public String getDefaultUrlByAPCUrl(String currentApcUrl) {
        if (currentApcUrl != null) {
            currentApcUrl = currentApcUrl.replaceFirst("(?i)/apc", "");
            for (Map.Entry actionMapping : APC_ACTION_MAPPINGS.entrySet()) {
                for (String apcUrl : (List)actionMapping.getValue()) {
                    if (!apcUrl.equalsIgnoreCase(currentApcUrl)) continue;
                    return (String)actionMapping.getKey();
                }
            }
        }
        return null;
    }

    public String getAPCRelativeUrl(HttpServletRequest request) {
        ConvertedPath path = this.getPath(request);
        if (APC_ACTION_MAPPINGS.containsKey(path.getUrl())) {
            String mappedApcUrl = APC_ACTION_MAPPINGS.getFirstForKey(path.getUrl());
            String cfPath = path.getPath(request.getParameterMap());
            String apcPath = cfPath.replaceFirst(Pattern.quote(path.getUrl()), mappedApcUrl);
            return this.bootstrapManager.getWebAppContextPath() + "/apc" + apcPath;
        }
        return null;
    }

    private ConvertedPath getPath(HttpServletRequest request) {
        if (request.getServletPath().equalsIgnoreCase(SERVLET_PATH_CONVERTIBLE_URL)) {
            String pathInfo = GeneralUtil.urlDecode((String)request.getPathInfo());
            if (StringUtils.isNotEmpty((String)(pathInfo = SimpleDisplayServlet.stripSlashes((String)pathInfo)))) {
                for (PathConverter pathConverter : this.pathConverterManager.getPathConverters()) {
                    if (!pathConverter.handles(pathInfo)) continue;
                    return pathConverter.getPath(pathInfo);
                }
            }
        }
        return new ConvertedPath(request.getServletPath());
    }

    private String substitutePlaceholdersInStorage(String storageFormat, @Nullable Long contentId) throws ParserConfigurationException, SAXException, IOException {
        if (contentId == null) {
            return storageFormat;
        }
        String editedStorageFormat = null;
        Map abstractPageObject = (Map)this.placeholderUtils.getObject(contentId);
        if (abstractPageObject != null && abstractPageObject.get("non_editable.elements") != null) {
            Map nonEditableNodesFromSession = (Map)abstractPageObject.get("non_editable.elements");
            if (nonEditableNodesFromSession != null) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                dbFactory.setValidating(false);
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new InputSource(new StringReader("<root>" + storageFormat + "</root>")));
                doc.getDocumentElement().normalize();
                Element rootEl = doc.getDocumentElement();
                HashMap<Integer, Node> nonEditNodesFromStorage = new HashMap<Integer, Node>();
                this.findAllNonEditNodesPlaceholders(rootEl, nonEditNodesFromStorage);
                if (!nonEditNodesFromStorage.isEmpty()) {
                    for (Map.Entry entry : nonEditNodesFromStorage.entrySet()) {
                        Node nonEditableNodeFromSession = (Node)nonEditableNodesFromSession.get(entry.getKey());
                        if (nonEditableNodeFromSession != null) {
                            ((Node)entry.getValue()).getParentNode().replaceChild(doc.adoptNode(nonEditableNodeFromSession), (Node)entry.getValue());
                            continue;
                        }
                        ((Node)entry.getValue()).getParentNode().removeChild((Node)entry.getValue());
                    }
                }
                editedStorageFormat = this.generateInnerXml(rootEl);
            }
            this.placeholderUtils.removeObject(contentId);
        }
        return editedStorageFormat != null ? editedStorageFormat : storageFormat;
    }

    public String convertWikiMarkupToWysiwyg(ContentRepresentation contentRepresentation, long pageId) {
        return this.convertWikiMarkupToWysiwyg(contentRepresentation, pageId, pageId);
    }

    public String convertWikiMarkupToWysiwyg(ContentRepresentation contentRepresentation, long pageId, long contentId) {
        AbstractPage abstractPage = this.pageManager.getAbstractPage(pageId);
        if (abstractPage != null) {
            return this.getConvertedWysiwygContent(contentRepresentation, (ConversionContext)new DefaultConversionContext((RenderContext)new PageContext((ContentEntityObject)abstractPage)), contentId);
        }
        return "";
    }

    public String convertWikiMarkupToWysiwyg(ContentRepresentation contentRepresentation, String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space != null) {
            return this.getConvertedWysiwygContent(contentRepresentation, (ConversionContext)new DefaultConversionContext((RenderContext)new PageContext(spaceKey)), null);
        }
        return "";
    }

    private String getConvertedWysiwygContent(ContentRepresentation contentRepresentation, ConversionContext conversionContext, Long contentId) {
        ArrayList conversionExceptions = new ArrayList();
        try {
            String storageFormat;
            if (contentRepresentation.hasLayout()) {
                String storageFormatWithCellPlaceholders = contentRepresentation.getStorageFormatWithPlaceholders();
                for (LayoutCell layoutCell : contentRepresentation.getLayoutCells()) {
                    String storageFormatWithUnmigratedWikiMarkupPlaceholders = this.xhtmlContent.convertWikiToStorage(layoutCell.getWikiMarkup(), conversionContext, conversionExceptions);
                    String cellStorageFormat = this.substitutePlaceholdersInStorage(storageFormatWithUnmigratedWikiMarkupPlaceholders, contentId);
                    storageFormatWithCellPlaceholders = storageFormatWithCellPlaceholders.replace("placeholder-" + layoutCell.getId(), cellStorageFormat);
                }
                storageFormat = storageFormatWithCellPlaceholders;
            } else {
                String storageFormatWithUnmigratedWikiMarkupPlaceholders = this.xhtmlContent.convertWikiToStorage(contentRepresentation.getLayoutCells().get(0).getWikiMarkup(), conversionContext, conversionExceptions);
                storageFormat = this.substitutePlaceholdersInStorage(storageFormatWithUnmigratedWikiMarkupPlaceholders, contentId);
            }
            return this.formatConverter.convertToEditorFormat(storageFormat, (RenderContext)conversionContext.getPageContext());
        }
        catch (Exception e) {
            LOGGER.error("error converting the wiki-markup. returning an empty String.", (Throwable)e);
            return "";
        }
    }

    private void findAllNonEditNodesPlaceholders(Node rootEl, Map<Integer, Node> nonEditableNodes) throws IOException, SAXException, ParserConfigurationException {
        Integer brokenId = -1;
        for (Node node : XmlUtil.asList(rootEl.getChildNodes())) {
            Integer placeholderId = this.getPlaceholderId(node);
            if (placeholderId == null) {
                if (node.getNodeType() != 1) continue;
                this.findAllNonEditNodesPlaceholders(node, nonEditableNodes);
                continue;
            }
            if (placeholderId > 0) {
                nonEditableNodes.put(placeholderId, node);
                continue;
            }
            nonEditableNodes.put(brokenId, node);
            Integer n = brokenId;
            Integer n2 = brokenId = Integer.valueOf(brokenId - 1);
        }
    }

    private Integer getPlaceholderId(Node node) throws ParserConfigurationException, IOException, SAXException {
        Node idNodeContent;
        Node placeholderIdNode;
        if (node.getNodeName().equals("ac:structured-macro") && node.hasAttributes() && node.getAttributes().getNamedItem("ac:name") != null && node.getAttributes().getNamedItem("ac:name").getNodeValue().equals(PLACEHOLDER_MACRO_NAME) && (placeholderIdNode = node.getFirstChild()).getNodeName().equals("ac:parameter") && placeholderIdNode.hasAttributes() && placeholderIdNode.getAttributes().getNamedItem("ac:name") != null && placeholderIdNode.getAttributes().getNamedItem("ac:name").getNodeValue().equals("id") && (idNodeContent = placeholderIdNode.getFirstChild()).getNodeType() == 3) {
            try {
                return Integer.parseInt(idNodeContent.getNodeValue());
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                LOGGER.debug("APC Mode: Placeholder with bad ID of a non editable element was found and will be ignored");
                return 0;
            }
        }
        return null;
    }

    public String generateInnerXml(Node node) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)node.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer lsSerializer = lsImpl.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("xml-declaration", false);
        StringBuilder xml = new StringBuilder();
        for (Node childNode : XmlUtil.asList(node.getChildNodes())) {
            xml.append(lsSerializer.writeToString(childNode));
        }
        return xml.toString();
    }

    public void setAPCMode(@Nullable ConfluenceUser user, @Nullable HttpSession httpSession, boolean apcMode) {
        PropertySet propertySet = this.userAccessor.getPropertySet(user);
        if (propertySet != null) {
            propertySet.setBoolean("de.communardo.confluence.plugins.apc.mode.active", apcMode);
        }
        this.setModeToSession(apcMode, httpSession);
    }

    private void setModeToSession(boolean apcMode, HttpSession httpSession) {
        if (httpSession != null) {
            httpSession.setAttribute("screenReaderMode", (Object)apcMode);
        }
    }

    public MacroDefinition getSpecificMacroDef(PageContext pageContext, String content, final String macroName) {
        final ArrayList macros = new ArrayList();
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)pageContext);
        try {
            this.xhtmlContent.handleMacroDefinitions(content, (ConversionContext)conversionContext, new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    if (macroDefinition.getName().equalsIgnoreCase(macroName)) {
                        macros.add(macroDefinition);
                    }
                }
            });
        }
        catch (XhtmlException xhtmlException) {
            // empty catch block
        }
        return macros.isEmpty() ? null : (MacroDefinition)macros.get(0);
    }

    public ContentRepresentation getContentRepresentationFromRequestParameters(Map<String, String[]> parameters) {
        ContentRepresentation contentRepresentation = null;
        ArrayList<LayoutCell> layoutCells = new ArrayList<LayoutCell>();
        String storageFormatWithPlaceholders = null;
        int placeholdersNumber = 0;
        if (parameters.containsKey("storageFormatWithPlaceholders")) {
            String[] storageFormatWithPlaceholdersValue = parameters.get("storageFormatWithPlaceholders");
            storageFormatWithPlaceholders = storageFormatWithPlaceholdersValue[0];
            placeholdersNumber = StringUtils.countMatches((String)storageFormatWithPlaceholders, (String)"placeholder-");
        }
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (!entry.getKey().startsWith("layout-cell_")) continue;
            int indexOfNumber = entry.getKey().indexOf("_") + 1;
            try {
                layoutCells.add(new LayoutCell(Integer.parseInt(entry.getKey().substring(indexOfNumber)), entry.getValue()[0]));
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Ignored the parameter {}", (Object)entry.getKey());
            }
        }
        if (layoutCells.size() >= 1 && storageFormatWithPlaceholders != null) {
            if (placeholdersNumber == layoutCells.size()) {
                contentRepresentation = ContentRepresentation.createWithLayout(layoutCells, storageFormatWithPlaceholders);
            }
        } else if (layoutCells.size() == 1 && storageFormatWithPlaceholders == null) {
            contentRepresentation = ContentRepresentation.createWithoutLayout(((LayoutCell)layoutCells.get(0)).getWikiMarkup());
        }
        return contentRepresentation;
    }

    public boolean isCF57OrNewer() {
        return Integer.parseInt(GeneralUtil.getBuildNumber()) >= 5780;
    }

    public boolean isCF58OrNewer() {
        return Integer.parseInt(GeneralUtil.getBuildNumber()) >= 5980;
    }

    static {
        APC_ACTION_MAPPINGS.addValueForKey("/pages/viewpage.action", "/pages/viewpage.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/viewpage.action", "/pages/viewinlinecomments.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/createpage.action", "/pages/createpage.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/editpage.action", "/pages/editpage.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/removepage.action", "/pages/removepage.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/viewblogposts.action", "/pages/viewblogposts.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/viewrecentblogposts.action", "/pages/viewblogposts.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/createblogpost.action", "/pages/createblogpost.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/editblogpost.action", "/pages/editblogpost.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/removeblogpost.action", "/pages/removeblogpost.action");
        APC_ACTION_MAPPINGS.addValueForKey("/index.action", "/dashboard.action");
        APC_ACTION_MAPPINGS.addValueForKey("/dashboard.action", "/dashboard.action");
        APC_ACTION_MAPPINGS.addValueForKey("/dosearchsite.action", "/apcdosearchsite.action");
        APC_ACTION_MAPPINGS.addValueForKey("/searchsite.action", "/searchsite.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/removecomment.action", "/pages/removecomment.action");
        APC_ACTION_MAPPINGS.addValueForKey("/spacedirectory/view.action", "/spacedirectory/view.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/viewmyprofile.action", "/users/viewmyprofile.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/viewmyfavourites.action", "/users/viewmyfavourites.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/viewnotifications.action", "/users/viewnotifications.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/editmyprofile.action", "/users/editmyprofile.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/viewuserprofile.action", "/users/viewuserprofile.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/viewmysettings.action", "/users/editmysettings.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/editmysettings.action", "/users/editmysettings.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/profile/editmyprofilepicture.action", "/users/editmyprofilepicture.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/changemypassword.action", "/users/changemypassword.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/editmyemailsettings.action", "/users/editmyemailsettings.action");
        APC_ACTION_MAPPINGS.addValueForKey("/users/viewmyemailsettings.action", "/users/editmyemailsettings.action");
        APC_ACTION_MAPPINGS.addValueForKey("/pages/viewpageattachments.action", "/pages/viewpageattachments.action");
        APC_ACTION_MAPPINGS.addValueForKey("/spaces/viewspace.action", "/spaces/viewspace.action");
        APC_ACTION_MAPPINGS.addValueForKey("/browsepeople.action", "/browsepeople.action");
        APC_ACTION_MAPPINGS.addValueForKey("/communardo/userprofile/indexofpersons.action", "/browsepeople.action");
        APC_ACTION_MAPPINGS.addValueForKey("/peopledirectory.action", "/browsepeople.action");
        APC_ACTION_MAPPINGS.addValueForKey("/dopeopledirectorysearch.action", "/dopeopledirectorysearch.action");
        APC_ACTION_MAPPINGS.addValueForKey("/spaces/viewspacesummary.action", "/spaces/viewspacesummary.action");
        APC_ACTION_MAPPINGS.addValueForKey("/spaces/editspace.action", "/spaces/editspace.action");
        APC_ACTION_MAPPINGS.addValueForKey("/spaces/editspacelabels.action", "/spaces/editspacelabels.action");
    }
}

