/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.service;

import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.pages.AbstractPage;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import de.communardo.confluence.plugins.apc.util.PlaceholderUtils;
import de.communardo.confluence.plugins.apc.util.SFtoWMTransformer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class AbstractPageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPageService.class);
    public static boolean velocityIsReady = false;
    private PlaceholderUtils placeholderUtils;
    private SFtoWMTransformer theSFtoWMTransformer;

    public AbstractPageService(PlaceholderUtils placeholderUtils, SFtoWMTransformer theSFtoWMTransformer) {
        this.placeholderUtils = placeholderUtils;
        this.theSFtoWMTransformer = theSFtoWMTransformer;
    }

    public void storeAbstractPageObject(AbstractPage abstractPage, Map<Integer, Node> nonEditEls) {
        HashMap<String, Object> abstractPageMap = new HashMap<String, Object>();
        abstractPageMap.put("content.id", abstractPage.getId());
        abstractPageMap.put("non_editable.elements", nonEditEls);
        this.placeholderUtils.setObject(abstractPage.getId(), abstractPageMap);
    }

    public ContentRepresentation getContentRepresentation(AbstractPage abstractPage) {
        ContentRepresentation contentRepresentation = null;
        if (abstractPage != null && abstractPage.getBodyContent().getBodyType() == BodyType.XHTML) {
            SFtoWMTransformer.TransformResult transformResult = this.theSFtoWMTransformer.transform(abstractPage);
            contentRepresentation = transformResult.getContentRepresentation();
            if (contentRepresentation != null) {
                this.storeAbstractPageObject(abstractPage, transformResult.getNonTransformableElements());
            } else {
                LOGGER.debug("cannot transform abstract page with id {} to wiki-markup.", (Object)abstractPage.getId());
            }
        } else {
            LOGGER.debug("cannot transform abstract page {} to wiki-markup because it neither exists nor contains XHTML.", (Object)abstractPage);
        }
        return contentRepresentation;
    }
}

