/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.rest;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import de.communardo.confluence.plugins.apc.entity.PageEntity;
import de.communardo.confluence.plugins.apc.util.APCHelper;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
@Produces(value={"application/json"})
public class APCRestHelper {
    private PageManager pageManager;
    private APCHelper apcHelper;

    public APCRestHelper(PageManager pageManager, APCHelper apcHelper) {
        this.pageManager = pageManager;
        this.apcHelper = apcHelper;
    }

    @GET
    @Path(value="pageTree/{pageId}")
    public Response getPageTree(@PathParam(value="pageId") String pageIdString) {
        try {
            int pageId = Integer.valueOf(pageIdString);
            Page page = this.pageManager.getPage((long)pageId);
            if (page != null) {
                List<PageEntity> pageTree = this.apcHelper.getPageTree(page);
                return Response.status((int)200).entity(pageTree).build();
            }
            return Response.status((int)404).entity((Object)("\"Could not find page with id: " + pageIdString + "\"")).build();
        }
        catch (NumberFormatException e) {
            return Response.status((int)400).entity((Object)("\"Cannot parse id. Wrong page id string provided: " + pageIdString + "\"")).build();
        }
    }
}

