/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.macro.recentlycontent.search;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilderFactory;
import de.communardo.confluence.plugins.apc.macro.recentlycontent.search.RecentlyContentSearchBuilder;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentlyContentSearcher {
    private static final Logger LOG = LoggerFactory.getLogger(RecentlyContentSearcher.class);
    private SearchManager searchManager;
    private final RecentlyContentSearchBuilder recentlyContentSearchBuilder;

    public RecentlyContentSearcher(SearchManager searchManager, ContentSearchBuilderFactory contentSearchBuilderFactory) {
        this.searchManager = searchManager;
        this.recentlyContentSearchBuilder = new RecentlyContentSearchBuilder(contentSearchBuilderFactory);
    }

    public List<AbstractPage> findRecentlyContent(boolean searchBlogPosts) {
        try {
            ISearch search = this.recentlyContentSearchBuilder.getRecentlyContentSearch(searchBlogPosts);
            if (search != null) {
                SearchResults searchResults = this.searchManager.search(search);
                return Lists.newArrayList((Iterable)Collections2.transform((Collection)this.searchManager.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION), (Function)new Function<Searchable, AbstractPage>(){

                    public AbstractPage apply(Searchable searchable) {
                        return (AbstractPage)searchable;
                    }
                }));
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Exception occurred during blogpost search", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

