/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.search.ContentSearchResult;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.model.search.SpaceSearchResult;
import com.atlassian.confluence.api.model.search.UserSearchResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.search.SearchPerformedEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.search.plugin.SiteSearchPluginModule;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.DateRangeEnum;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.core.util.PairType;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.communardo.confluence.plugins.apc.action.ImportedClasses.ImportedCQLSearcher;
import de.communardo.confluence.plugins.apc.action.ImportedClasses.ImportedSearchActionParameterMigrator;
import de.communardo.confluence.plugins.apc.common.SpacePickerHelper;
import de.communardo.confluence.plugins.apc.compatibility.search.SearchQueryParameterWrapper;
import de.communardo.confluence.plugins.apc.exception.FaultySearchResultException;
import de.communardo.confluence.plugins.apc.util.ChuckNorris;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class APCSearchAction
extends ConfluenceActionSupport
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(APCSearchAction.class);
    private static final int MAX_RESULTS_PER_PAGE = 10;
    private static final int NO_MATCH_EXCERPT_SIZE = 320;
    private String queryString;
    private String where;
    private DateRangeEnum lastModifiedFilter;
    private String type;
    private String contributor;
    private int startIndex;
    private String contributorUsername;
    private PaginationSupport paginationSupport = new PaginationSupport(10);
    private UUID sessionUuid;
    private final List<SearchResultTransfer> results = new LinkedList<SearchResultTransfer>();
    private int totalSearchResults;
    private String cql;
    private ImportedCQLSearcher cqlSearcher;
    private SpaceManager spaceManager;
    private AttachmentManager attachmentManager;
    private List<SearchResult> cqlSearchResults;
    private EventPublisher eventPublisher;
    private SpacePickerHelper spacePickerHelper;

    public void afterPropertiesSet() throws Exception {
        this.spacePickerHelper = new SpacePickerHelper(this.spaceManager, this.labelManager);
    }

    public void validate() {
        if (this.sessionUuid == null) {
            this.sessionUuid = UUID.randomUUID();
        }
        super.validate();
    }

    public String execute() throws Exception {
        SearchQueryParameters searchParams = SearchQueryParameters.newSearchQueryParameters((String)this.getQueryString()).where(this.where).pluggableContentType(ChuckNorris.pleaseGive(PluginAccessor.class), this.getType()).lastModified(this.lastModifiedFilter).contributor(!StringUtils.isEmpty((String)this.getContributor()) ? this.getContributor() : (!StringUtils.isEmpty((String)this.getContributorUsername()) ? this.getContributorUsername() : null)).startIndex(this.getStartIndex()).build();
        return this.doCqlSearch(searchParams);
    }

    private String doCqlSearch(SearchQueryParameters searchQuery) throws Exception {
        if (Strings.isNullOrEmpty((String)this.cql)) {
            this.cql = ImportedSearchActionParameterMigrator.migrate(searchQuery);
        }
        String sessionUuidStr = this.sessionUuid.toString();
        RequestCacheThreadLocal.getRequestCache().put("search-query-session-uuid", sessionUuidStr);
        try {
            ImportedCQLSearcher.SearchResultTotalSize cqlResultObject = this.cqlSearcher.getCqlSearchResults(this.cql, searchQuery);
            this.cqlSearchResults = cqlResultObject.getSearchResult();
            this.totalSearchResults = cqlResultObject.getTotalSize();
        }
        catch (BadRequestException var4) {
            this.setActionErrors(Collections.singletonList(var4.getMessage()));
        }
        if (this.cqlSearchResults.size() > 0) {
            for (SearchResult result : this.cqlSearchResults) {
                try {
                    this.results.add(new SearchResultTransfer(result));
                }
                catch (FaultySearchResultException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
        this.paginationSupport.setTotal(this.totalSearchResults);
        this.paginationSupport.setStartIndex(this.startIndex);
        SearchQuery searchQueryForEvent = SearchQueryParameterWrapper.toSearchV2Query(searchQuery, (Map<String, String>)ImmutableMap.of((Object)"sessionUuid", (Object)sessionUuidStr));
        SearchPerformedEvent searchPerformedEvent = new SearchPerformedEvent((Object)this, searchQueryForEvent, (User)AuthenticatedUserThreadLocal.get(), this.results.size());
        this.eventManager.publishEvent((Event)searchPerformedEvent);
        return this.hasActionErrors() ? "error" : "success";
    }

    public boolean isSearchPerformed() {
        return this.getQueryString() != null;
    }

    public List<SearchResultTransfer> getResults() {
        return this.results;
    }

    public int getTotalSearchResults() {
        return this.totalSearchResults;
    }

    public int getEndIndex() {
        return Math.min(this.getStartIndex() + 10, this.totalSearchResults);
    }

    public List<SpacePickerHelper.SpaceDTO> getSpaces() {
        return this.spacePickerHelper.getAvailableGlobalSpaces(this.getAuthenticatedUser());
    }

    public List<PairType> getSpaceGroups() {
        return this.spacePickerHelper.getAggregateOptions(this);
    }

    public List<PairType> getTypeOptions() {
        ArrayList<PairType> typeOptions = new ArrayList<PairType>(9);
        typeOptions.add(new PairType(null, (Serializable)((Object)this.getText("type.allcontent"))));
        typeOptions.add(new PairType((Serializable)((Object)ContentTypeEnum.PAGE.getRepresentation()), (Serializable)((Object)this.getText("type.pages"))));
        typeOptions.add(new PairType((Serializable)((Object)ContentTypeEnum.BLOG.getRepresentation()), (Serializable)((Object)this.getText("type.newsitems"))));
        typeOptions.add(new PairType((Serializable)((Object)ContentTypeEnum.COMMENT.getRepresentation()), (Serializable)((Object)this.getText("type.comments"))));
        typeOptions.add(new PairType((Serializable)((Object)ContentTypeEnum.ATTACHMENT.getRepresentation()), (Serializable)((Object)this.getText("type.attachments"))));
        typeOptions.add(new PairType((Serializable)((Object)ContentTypeEnum.PERSONAL_INFORMATION.getRepresentation()), (Serializable)((Object)this.getText("type.profiles"))));
        typeOptions.add(new PairType((Serializable)((Object)ContentTypeEnum.SPACE_DESCRIPTION.getRepresentation()), (Serializable)((Object)this.getText("type.space.desc"))));
        List siteSearchPluginModules = this.pluginAccessor.getEnabledModulesByClass(SiteSearchPluginModule.class);
        siteSearchPluginModules.stream().flatMap(module -> module.getContentTypeDescriptors().stream()).forEach(descriptor -> typeOptions.add(new PairType((Serializable)((Object)descriptor.getIdentifier()), (Serializable)((Object)this.getText(descriptor.getI18NKey())))));
        return typeOptions;
    }

    public List<PairType> getDateRanges() {
        ArrayList<PairType> dateRanges = new ArrayList<PairType>(5);
        dateRanges.add(new PairType(null, (Serializable)((Object)this.getText("modified.any.date"))));
        dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTDAY.name()), (Serializable)((Object)this.getText("modified.today"))));
        dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTTWODAYS.name()), (Serializable)((Object)this.getText("modified.yesterday"))));
        dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTWEEK.name()), (Serializable)((Object)this.getText("modified.lastweek"))));
        dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTMONTH.name()), (Serializable)((Object)this.getText("modified.lastmonth"))));
        dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTSIXMONTHS.name()), (Serializable)((Object)this.getText("modified.lastsixmonths"))));
        dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTYEAR.name()), (Serializable)((Object)this.getText("modified.lastyear"))));
        dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTTWOYEARS.name()), (Serializable)((Object)this.getText("modified.lasttwoyears"))));
        return dateRanges;
    }

    public String getQueryParameters() {
        StringBuilder result = new StringBuilder();
        result.append("&").append("queryString=").append(GeneralUtil.urlEncode((String)(this.getQueryString() != null ? this.queryString : "")));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.where)) {
            result.append("&").append("where=").append(GeneralUtil.urlEncode((String)this.where));
        } else {
            result.append("&").append("where=").append(GeneralUtil.urlEncode((String)SpaceCategoryEnum.ALL.getRepresentation()));
        }
        result.append("&").append("type=").append(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.type) ? GeneralUtil.urlEncode((String)this.getType()) : "");
        result.append("&").append("lastModifiedFilter=").append(this.lastModifiedFilter != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.lastModifiedFilter.name()) ? GeneralUtil.urlEncode((String)this.lastModifiedFilter.name()) : "");
        result.append("&").append("contributor=").append(this.contributor != null ? GeneralUtil.urlEncode((String)this.contributor) : "");
        result.append("&").append("contributorUsername=").append(this.contributorUsername != null ? GeneralUtil.urlEncode((String)this.contributorUsername) : "");
        return result.toString().substring(1);
    }

    public String getQueryString() {
        return this.queryString;
    }

    @ParameterSafe
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getWhere() {
        return this.where;
    }

    @ParameterSafe
    public void setWhere(String where) {
        this.where = where;
    }

    public String getType() {
        return this.type != null && this.type.length() != 0 ? this.type : null;
    }

    @ParameterSafe
    public void setType(String type) {
        this.type = type;
    }

    public String getLastModifiedFilter() {
        return this.lastModifiedFilter != null ? this.lastModifiedFilter.name() : null;
    }

    @ParameterSafe
    public void setLastModifiedFilter(String lastModified) {
        this.lastModifiedFilter = StringUtils.isNotEmpty((String)lastModified) ? DateRangeEnum.valueOf((String)lastModified.toUpperCase()) : null;
    }

    public String getContributor() {
        return this.contributor;
    }

    @ParameterSafe
    public void setContributor(String who) {
        this.contributor = who;
    }

    public String getContributorUsername() {
        return this.contributorUsername;
    }

    @ParameterSafe
    public void setContributorUsername(String contributorUsername) {
        this.contributorUsername = contributorUsername;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    @ParameterSafe
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setPaginationSupport(PaginationSupport paginationSupport) {
        this.paginationSupport = paginationSupport;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setCQLSearcher(ImportedCQLSearcher cqlSearcher) {
        this.cqlSearcher = cqlSearcher;
    }

    public String getCql() {
        return this.cql;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public List<SearchResult> getCqlSearchResults() {
        return this.cqlSearchResults;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public class SearchResultTransfer {
        private final String title;
        private final String summary;
        private final String contentType;
        private final String url;
        private final String spaceKey;
        private final String spaceName;
        private final String lastModification;
        private final String creator;
        private final String attachmentDownloadPath;
        private final String containingContentDisplayTitle;
        private final String containingContentUrlPath;
        private final String creatorFullName;
        private String username;
        private String email;

        public SearchResultTransfer(SearchResult result) throws FaultySearchResultException {
            this.title = GeneralUtil.htmlEncode((String)this.deHighlighting(result.getTitle()));
            this.summary = this.getSummaryForResult(result);
            this.contentType = this.getContentTypeForResult(result);
            this.url = result.getUrl();
            this.spaceKey = this.getSpaceKeyForResult(result);
            this.spaceName = this.getSpaceNameForResult(result);
            this.lastModification = this.getLastModificationForResult(result);
            ConfluenceUser user = this.getUserForResult(result);
            String string = this.creator = user != null ? user.getName() : "";
            if (this.contentType.equals(ContentTypeEnum.ATTACHMENT.getRepresentation())) {
                long attachmentId = ((ContentSearchResult)result).getContent().getId().asLong();
                Attachment attachment = APCSearchAction.this.attachmentManager.getAttachment(attachmentId);
                this.attachmentDownloadPath = attachment.getDownloadPath();
            } else {
                this.attachmentDownloadPath = "";
            }
            this.containingContentDisplayTitle = result.getTitle() != null ? result.getTitle() : "";
            this.containingContentUrlPath = result.getUrl() != null ? result.getUrl() : "";
            String string2 = this.creatorFullName = user != null ? user.getFullName() : "";
            if (result instanceof UserSearchResult) {
                this.username = ((UserSearchResult)result).getUser().getUsername();
                this.email = user != null ? user.getEmail() : "";
            }
        }

        private String getSummaryForResult(SearchResult result) {
            String content = result.getExcerpt();
            String title = result.getTitle();
            if ((content = this.deHighlighting(content)) != null && content.length() > 3 && content.substring(content.length() - 3, content.length() - 1).equals("...")) {
                content = content.substring(0, content.length() - 4);
            }
            String string = content = content != null && content.startsWith(title) ? this.deHighlighting(content.substring(title.length())) : this.deHighlighting(content);
            return content == null ? "" : GeneralUtil.htmlEncode((String)(content.length() <= 320 ? content : content.substring(0, 320) + "..."));
        }

        private String getContentTypeForResult(SearchResult result) {
            String contentType = "";
            contentType = result instanceof ContentSearchResult ? ((ContentSearchResult)result).getContent().getType().getValue() : (result instanceof UserSearchResult ? "userinfo" : result.getEntityType());
            return contentType;
        }

        private String getSpaceKeyForResult(SearchResult result) throws FaultySearchResultException {
            String spaceKey = null;
            if (result instanceof SpaceSearchResult) {
                spaceKey = ((SpaceSearchResult)result).getSpace().getKey();
            } else if (result instanceof ContentSearchResult) {
                Content content = ((ContentSearchResult)result).getContent();
                try {
                    spaceKey = content.getSpaceRef().getIdProperties().values().iterator().next().toString();
                }
                catch (NoSuchElementException e) {
                    throw new FaultySearchResultException("No spaceKey available for content with id " + content.getId().asLong() + ".", result);
                }
            }
            return spaceKey != null ? spaceKey : "";
        }

        private String getSpaceNameForResult(SearchResult result) throws FaultySearchResultException {
            String spaceKey = this.getSpaceKeyForResult(result);
            Space space = !spaceKey.isEmpty() ? APCSearchAction.this.spaceManager.getSpace(spaceKey) : null;
            return space != null ? space.getName() : "";
        }

        private String getLastModificationForResult(SearchResult result) {
            String lastModificationDate = result.getFriendlyLastModified();
            return lastModificationDate != null ? GeneralUtil.htmlEncode((String)lastModificationDate) : "";
        }

        private ConfluenceUser getUserForResult(SearchResult result) {
            if (result instanceof UserSearchResult) {
                return APCSearchAction.this.userAccessor.getUserByKey((UserKey)((UserSearchResult)result).getUser().optionalUserKey().get());
            }
            return null;
        }

        private String deHighlighting(String string) {
            return string != null ? string.replaceAll("@@@hl@@@", "").replaceAll("@@@endhl@@@", "") : null;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public String getSpaceName() {
            return this.spaceName;
        }

        public String getLastModification() {
            return this.lastModification;
        }

        public String getCreator() {
            return this.creator;
        }

        public String getAttachmentDownloadPath() {
            return this.attachmentDownloadPath;
        }

        public String getContainingContentDisplayTitle() {
            return this.containingContentDisplayTitle;
        }

        public String getContainingContentUrlPath() {
            return this.containingContentUrlPath;
        }

        public String getCreatorFullName() {
            return this.creatorFullName;
        }

        public String getUsername() {
            return this.username;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

